<?php

namespace App\Http\Controllers;

use App\Models\Favourite;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class FavouriteController extends Controller
{
    public function index()
    {
        $favourites = Favourite::with('product')
            ->where('user_id', Auth::id())
            ->get();
        return view('favourites.index', compact('favourites'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'product_id' => 'required|exists:products,id',
        ]);
        $userId = Auth::id();
        $productId = $request->product_id;
        $favourite = Favourite::firstOrCreate([
            'user_id' => $userId,
            'product_id' => $productId,
        ]);
        return response()->json(['success' => true, 'favourite' => $favourite]);
    }

    public function destroy(Request $request)
    {
        $request->validate([
            'product_id' => 'required|exists:products,id',
        ]);
        $userId = Auth::id();
        Favourite::where('user_id', $userId)
            ->where('product_id', $request->product_id)
            ->delete();
        return response()->json(['success' => true]);
    }

    public function count()
    {
        $count = 0;
        if (auth()->check()) {
            $count = \App\Models\Favourite::where('user_id', auth()->id())->count();
        }
        return response()->json(['count' => $count]);
    }
} 