<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Category;
use App\Models\Brand;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index(Request $request)
    {
        $currency = $request->get('currency', session('currency', 'USD'));
        session(['currency' => $currency]);

        $featuredProducts = Product::active()
            ->where('is_featured', true)
            ->with(['category', 'vendor'])
            ->latest()
            ->take(8)
            ->get();

        $latestProducts = Product::active()
            ->with(['category', 'vendor'])
            ->latest()
            ->take(8)
            ->get();

        $categories = Category::active()
            ->withCount('products')
            ->take(6)
            ->get();

        return view('home', compact('featuredProducts', 'latestProducts', 'categories', 'currency'));
    }

    public function search(Request $request)
    {
        $currency = $request->get('currency', session('currency', 'USD'));
        session(['currency' => $currency]);

        $query = $request->get('q', '');
        
        if (empty($query)) {
            return redirect()->route('products.index');
        }

        $products = Product::active()
            ->where(function($q) use ($query) {
                $q->where('name', 'LIKE', "%{$query}%")
                  ->orWhere('description', 'LIKE', "%{$query}%")
                  ->orWhere('short_description', 'LIKE', "%{$query}%")
                  ->orWhereHas('category', function($categoryQuery) use ($query) {
                      $categoryQuery->where('name', 'LIKE', "%{$query}%");
                  })
                  ->orWhereHas('vendor', function($vendorQuery) use ($query) {
                      $vendorQuery->where('name', 'LIKE', "%{$query}%");
                  });
            })
            ->with(['category', 'vendor'])
            ->paginate(12);

        $categories = Category::active()->withCount('products')->get();
        $vendors = \App\Models\Vendor::all();
        $tags = \App\Models\Tag::all();

        return view('product.index', compact('products', 'categories', 'vendors', 'tags', 'currency'));
    }
}
