<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;

class SetLocale
{
    public function handle(Request $request, Closure $next)
    {
        $locale = $request->get('lang', session('lang', 'en'));
        if (!in_array($locale, ['en', 'ru', 'az'])) {
            $locale = 'en';
        }
        \Log::debug('SetLocale middleware running. Locale: ' . $locale . ' | URL: ' . $request->fullUrl());
        App::setLocale($locale);
        session(['lang' => $locale]);
        return $next($request);
    }
} 