<?php

namespace App\Services\Payment;

use App\Models\Order;

interface PaymentServiceInterface
{
    /**
     * Initialize a payment
     *
     * @param Order $order
     * @return array Payment details
     */
    public function initializePayment(Order $order): array;

    /**
     * Process a payment
     *
     * @param Order $order
     * @param array $paymentData
     * @return bool
     */
    public function processPayment(Order $order, array $paymentData): bool;

    /**
     * Verify a payment
     *
     * @param Order $order
     * @param array $paymentData
     * @return bool
     */
    public function verifyPayment(Order $order, array $paymentData): bool;
} 