<?php

namespace App\Services\Payment;

use Illuminate\Support\ServiceProvider;

class PaymentServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->app->singleton(PaymentServiceInterface::class, function ($app) {
            $paymentGateway = config('payment.default_gateway', 'stripe');
            
            return match ($paymentGateway) {
                'stripe' => new StripePaymentService(),
                'local' => new LocalPaymentService(),
                default => throw new \InvalidArgumentException("Unsupported payment gateway: {$paymentGateway}"),
            };
        });
    }
} 