<?php

namespace App\Traits;

trait HasSeoMetadata
{
    /**
     * Get the SEO title for the model
     *
     * @return string
     */
    public function getSeoTitle(): string
    {
        return $this->meta_title ?? $this->name ?? $this->title ?? '';
    }

    /**
     * Get the SEO description for the model
     *
     * @return string
     */
    public function getSeoDescription(): string
    {
        return $this->meta_description ?? $this->description ?? '';
    }

    /**
     * Get the SEO keywords for the model
     *
     * @return string
     */
    public function getSeoKeywords(): string
    {
        return $this->meta_keywords ?? '';
    }

    /**
     * Get the canonical URL for the model
     *
     * @return string
     */
    public function getCanonicalUrl(): string
    {
        return url($this->getSeoPath());
    }

    /**
     * Get the SEO path for the model
     *
     * @return string
     */
    abstract public function getSeoPath(): string;

    /**
     * Get the Open Graph data for the model
     *
     * @return array
     */
    public function getOpenGraphData(): array
    {
        return [
            'title' => $this->getSeoTitle(),
            'description' => $this->getSeoDescription(),
            'url' => $this->getCanonicalUrl(),
            'type' => 'website',
            'site_name' => config('app.name'),
        ];
    }

    /**
     * Get the Twitter Card data for the model
     *
     * @return array
     */
    public function getTwitterCardData(): array
    {
        return [
            'card' => 'summary_large_image',
            'title' => $this->getSeoTitle(),
            'description' => $this->getSeoDescription(),
            'url' => $this->getCanonicalUrl(),
        ];
    }
} 