<?php

if (!function_exists('format_currency')) {
    /**
     * Format a price with currency symbol
     */
    function format_currency($amount, $currency = null)
    {
        if ($currency === null) {
            $currency = session('currency', 'USD');
        }
        
        $currencyService = app(\App\Services\CurrencyService::class);
        return $currencyService->formatPrice($amount, $currency);
    }
}

if (!function_exists('get_currency_symbol')) {
    /**
     * Get currency symbol
     */
    function get_currency_symbol($currency = null)
    {
        if ($currency === null) {
            $currency = session('currency', 'USD');
        }
        
        $currencyService = app(\App\Services\CurrencyService::class);
        return $currencyService->getSymbol($currency);
    }
}

if (!function_exists('convert_currency')) {
    /**
     * Convert amount between currencies
     */
    function convert_currency($amount, $fromCurrency, $toCurrency)
    {
        $currencyService = app(\App\Services\CurrencyService::class);
        return $currencyService->convert($amount, $fromCurrency, $toCurrency);
    }
} 