<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Default Payment Gateway
    |--------------------------------------------------------------------------
    |
    | This option controls the default payment gateway that will be used when
    | processing payments. Supported: "stripe", "local"
    |
    */
    'default_gateway' => env('PAYMENT_GATEWAY', 'stripe'),

    /*
    |--------------------------------------------------------------------------
    | Payment Gateways
    |--------------------------------------------------------------------------
    |
    | Here you may configure the payment gateways for your application.
    |
    */
    'gateways' => [
        'stripe' => [
            'key' => env('STRIPE_KEY'),
            'secret' => env('STRIPE_SECRET'),
            'webhook_secret' => env('STRIPE_WEBHOOK_SECRET'),
            'currency' => 'usd',
        ],
        'local' => [
            'merchant_id' => env('LOCAL_MERCHANT_ID'),
            'api_key' => env('LOCAL_API_KEY'),
            'currency' => 'azn',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Payment Methods
    |--------------------------------------------------------------------------
    |
    | Here you may configure the available payment methods.
    |
    */
    'methods' => [
        'stripe' => [
            'name' => 'Credit Card',
            'description' => 'Pay securely with your credit card',
            'icon' => 'credit-card',
        ],
        'local' => [
            'name' => 'Local Payment',
            'description' => 'Pay using local payment methods',
            'icon' => 'bank',
        ],
    ],
]; 