<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->enum('discount_type', ['percent', 'fixed'])->nullable()->after('sale_price');
            $table->decimal('discount_value', 10, 2)->nullable()->after('discount_type');
            $table->dateTime('discount_start')->nullable()->after('discount_value');
            $table->dateTime('discount_end')->nullable()->after('discount_start');
        });
    }

    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn(['discount_type', 'discount_value', 'discount_start', 'discount_end']);
        });
    }
}; 