<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        DB::table('products')->insert([
            [
                'category_id' => 1,
                'name' => json_encode(['en' => 'Smartphone', 'ru' => 'Смартфон', 'az' => 'Smartfon']),
                'slug' => 'smartphone',
                'description' => json_encode([
                    'en' => 'A modern smartphone with a great camera.',
                    'ru' => 'Современный смартфон с отличной камерой.',
                    'az' => 'Möhtəşəm kameralı müasir smartfon.'
                ]),
                'short_description' => json_encode([
                    'en' => 'Modern smartphone',
                    'ru' => 'Современный смартфон',
                    'az' => 'Müasir smartfon'
                ]),
                'price' => 499.99,
                'stock_quantity' => 50,
                'is_active' => true,
            ],
            [
                'category_id' => 2,
                'name' => json_encode(['en' => 'Tennis Racket', 'ru' => 'Теннисная ракетка', 'az' => 'Tennis raketkası']),
                'slug' => 'tennis-racket',
                'description' => json_encode([
                    'en' => 'Lightweight racket for professional play.',
                    'ru' => 'Легкая ракетка для профессиональной игры.',
                    'az' => 'Peşəkar oyun üçün yüngül raketka.'
                ]),
                'short_description' => json_encode([
                    'en' => 'Pro tennis racket',
                    'ru' => 'Проф. теннисная ракетка',
                    'az' => 'Peşəkar tennis raketkası'
                ]),
                'price' => 89.99,
                'stock_quantity' => 30,
                'is_active' => true,
            ],
        ]);
    }
} 