import './bootstrap';

import Alpine from 'alpinejs';

window.Alpine = Alpine;

Alpine.start();

// If using Livewire, ensure it uses the existing Alpine instance
window.deferLoadingAlpine = function (callback) {
    document.addEventListener('alpine:initialized', callback);
};

// Cart quantity increment/decrement and AJAX update

document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.cart-qty-form').forEach(function(form) {
        const input = form.querySelector('.cart-qty-input');
        const incBtn = form.querySelector('.increment-qty');
        const decBtn = form.querySelector('.decrement-qty');
        const productId = form.getAttribute('data-product-id');
        if (!input || !incBtn || !decBtn) return;

        incBtn.addEventListener('click', function() {
            let val = parseInt(input.value) || 1;
            const max = parseInt(input.getAttribute('max')) || 9999;
            if (val < max) {
                input.value = val + 1;
                triggerQtyChange(form, input, productId);
            }
        });
        decBtn.addEventListener('click', function() {
            let val = parseInt(input.value) || 1;
            if (val > 1) {
                input.value = val - 1;
                triggerQtyChange(form, input, productId);
            }
        });
        input.addEventListener('change', function() {
            let val = parseInt(input.value) || 1;
            const max = parseInt(input.getAttribute('max')) || 9999;
            if (val < 1) val = 1;
            if (val > max) val = max;
            input.value = val;
            triggerQtyChange(form, input, productId);
        });
    });

    function triggerQtyChange(form, input, productId) {
        const url = form.getAttribute('action');
        const token = form.querySelector('input[name="_token"]').value;
        const quantity = input.value;
        fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': token,
                'Accept': 'application/json',
            },
            body: JSON.stringify({
                product_id: productId,
                quantity: quantity
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update subtotal for this product
                const subtotalEl = document.getElementById('cart-subtotal-' + productId);
                if (subtotalEl) {
                    subtotalEl.textContent = data.subtotal;
                }
                // Update total
                document.querySelectorAll('.cart-total-amount').forEach(function(el) {
                    el.textContent = data.total;
                });
                // Optionally update cart count
                if (typeof updateCartCount === 'function') updateCartCount();
            } else {
                alert(data.message || 'Could not update cart.');
            }
        })
        .catch(() => {
            alert('Could not update cart.');
        });
    }
});
