@extends('layouts.admin')

@section('title', 'Admin - Brands')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-semibold text-gray-800">{{ __('admin.Brands') }}</h1>
        <a href="{{ route('admin.brands.create') }}" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
            {{ __('admin.Add New Brand') }}
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
            <p>{{ session('success') }}</p>
        </div>
    @endif

    <div class="bg-white shadow-md rounded-lg overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.Logo') }}</th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.Name') }}</th>
                        <th class="py-3 px-6 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.Actions') }}</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    @forelse($brands as $brand)
                        <tr class="hover:bg-gray-50" data-brand-id="{{ $brand->id }}">
                            <td class="py-4 px-6 whitespace-nowrap">
                                @if($brand->logo)
                                    <img src="{{ asset('storage/' . $brand->logo) }}" alt="{{ $brand->name }}" class="h-12 w-24 object-contain">
                                @else
                                    <span class="text-sm text-gray-500">{{ __('admin.No Logo') }}</span>
                                @endif
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm font-medium text-gray-900">
                                {{ $brand->name }}
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.brands.edit', $brand) }}" class="text-indigo-600 hover:text-indigo-900 mr-4">{{ __('admin.Edit') }}</a>
                                <button type="button" class="text-red-600 hover:text-red-900 delete-brand-btn" data-url="{{ route('admin.brands.destroy', $brand) }}">{{ __('admin.Delete') }}</button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="py-4 px-6 text-center text-gray-500">
                                {{ __('admin.No brands found.') }}
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection 

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-dismiss server-side success alert
    const serverAlert = document.querySelector('.bg-green-100[role="alert"]');
    if (serverAlert) {
        setTimeout(() => serverAlert.remove(), 500);
    }

    document.querySelectorAll('.delete-brand-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            const url = this.getAttribute('data-url');
            const row = this.closest('tr');
            fetch(url, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json',
                },
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    row.remove();
                    showBrandSuccess('{{ __('admin.Brand deleted successfully.') }}');
                } else {
                    alert(data.message || '{{ __('admin.Failed to delete brand.') }}');
                }
            })
            .catch(() => alert('{{ __('admin.Failed to delete brand.') }}'));
        });
    });

    function showBrandSuccess(msg) {
        let alert = document.createElement('div');
        alert.className = 'bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4';
        alert.role = 'alert';
        alert.innerHTML = `<p>${msg}</p>`;
        document.querySelector('.container').prepend(alert);
        setTimeout(() => alert.remove(), 500);
    }
});
</script>
@endpush 