@extends('layouts.admin')

@section('title', 'Admin - Categories')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-semibold text-gray-800">{{ __('admin.category_management') }}</h1>
        <a href="{{ route('admin.categories.create') }}" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
            {{ __('admin.add_new_category') }}
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
            <p>{{ session('success') }}</p>
        </div>
    @endif
    @if(session('error'))
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4" role="alert">
            <p>{{ session('error') }}</p>
        </div>
    @endif

    <div class="bg-white shadow-md rounded-lg overflow-hidden">
        <div class="px-6 py-4">
            <h2 class="text-xl font-semibold text-gray-700">{{ __('admin.all_categories') }}</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.id') }}</th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.name') }}</th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.slug') }}</th>
                        <th class="py-3 px-6 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.status') }}</th>
                        <th class="py-3 px-6 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.actions') }}</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    @forelse($categories as $category)
                        <tr class="hover:bg-gray-50">
                            <td class="py-4 px-6 whitespace-nowrap text-sm text-gray-500">{{ $category->id }}</td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm font-medium text-gray-900">{{ $category->name }}</td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm text-gray-500">{{ $category->slug }}</td>
                            <td class="py-4 px-6 whitespace-nowrap text-center">
                                @if($category->is_active)
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                        {{ __('admin.active') }}
                                    </span>
                                @else
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                        {{ __('admin.inactive') }}
                                    </span>
                                @endif
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.categories.edit', $category) }}" class="text-indigo-600 hover:text-indigo-900 mr-4">{{ __('admin.edit') }}</a>
                                <button type="button" class="text-red-600 hover:text-red-900 delete-category-btn" data-url="{{ route('admin.categories.destroy', $category) }}">{{ __('admin.delete') }}</button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="py-4 px-6 text-center text-gray-500">
                                {{ __('admin.no_categories_found') }}
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if ($categories->hasPages())
        <div class="px-6 py-4">
            {{ $categories->links() }}
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Auto-dismiss server-side success alert
    const serverAlert = document.querySelector('.bg-green-100[role="alert"]');
    if (serverAlert) {
        setTimeout(() => serverAlert.remove(), 500);
    }

    document.querySelectorAll('.delete-category-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            const url = this.getAttribute('data-url');
            const row = this.closest('tr');
            fetch(url, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json',
                },
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    row.remove();
                    showCategorySuccess('{{ __('admin.category_deleted_successfully') }}');
                } else {
                    alert(data.message || '{{ __('admin.failed_to_delete_category') }}');
                }
            })
            .catch(() => alert('{{ __('admin.failed_to_delete_category') }}'));
        });
    });

    function showCategorySuccess(msg) {
        let alert = document.createElement('div');
        alert.className = 'bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4';
        alert.role = 'alert';
        alert.innerHTML = `<p>${msg}</p>`;
        document.querySelector('.container').prepend(alert);
        setTimeout(() => alert.remove(), 500);
    }
});
</script>
@endpush 