@extends('layouts.admin')

@section('title', 'Admin - Add Product')

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-2xl font-semibold text-gray-800 mb-6">{{ __('admin.Add New Product') }}</h1>

    <form action="{{ route('admin.products.store') }}" method="POST" enctype="multipart/form-data" class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        @csrf
        
        <!-- Main Content -->
        <div class="lg:col-span-2">
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-xl font-semibold text-gray-700 mb-4">Product Information</h2>
                
                <!-- Language Tabs -->
                <div class="mb-6">
                    <div class="border-b border-gray-200">
                        <nav class="-mb-px flex space-x-8" aria-label="Tabs">
                            <button type="button" class="language-tab border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-2 px-1 border-b-2 font-medium text-sm active" data-lang="en">
                                English
                            </button>
                            <button type="button" class="language-tab border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-2 px-1 border-b-2 font-medium text-sm" data-lang="ru">
                                Русский
                            </button>
                            <button type="button" class="language-tab border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-2 px-1 border-b-2 font-medium text-sm" data-lang="az">
                                Azərbaycan
                            </button>
                        </nav>
                    </div>
                </div>

                <!-- English Content -->
                <div class="language-content" data-lang="en">
                    <!-- Product Name -->
                    <div class="mb-4">
                        <label for="name_en" class="block text-sm font-medium text-gray-700 mb-1">Product Name (English)</label>
                        <input type="text" id="name_en" name="name[en]" value="{{ old('name.en') }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" required>
                        @error('name.en')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Description -->
                    <div class="mb-4">
                        <label for="description_en" class="block text-sm font-medium text-gray-700 mb-1">Description (English)</label>
                        <textarea id="description_en" name="description[en]" rows="6" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('description.en') }}</textarea>
                        @error('description.en')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Short Description -->
                    <div>
                        <label for="short_description_en" class="block text-sm font-medium text-gray-700 mb-1">Short Description (English)</label>
                        <textarea id="short_description_en" name="short_description[en]" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('short_description.en') }}</textarea>
                         @error('short_description.en')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Russian Content -->
                <div class="language-content hidden" data-lang="ru">
                    <!-- Product Name -->
                    <div class="mb-4">
                        <label for="name_ru" class="block text-sm font-medium text-gray-700 mb-1">Product Name (Russian)</label>
                        <input type="text" id="name_ru" name="name[ru]" value="{{ old('name.ru') }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                        @error('name.ru')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Description -->
                    <div class="mb-4">
                        <label for="description_ru" class="block text-sm font-medium text-gray-700 mb-1">Description (Russian)</label>
                        <textarea id="description_ru" name="description[ru]" rows="6" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('description.ru') }}</textarea>
                        @error('description.ru')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Short Description -->
                    <div>
                        <label for="short_description_ru" class="block text-sm font-medium text-gray-700 mb-1">Short Description (Russian)</label>
                        <textarea id="short_description_ru" name="short_description[ru]" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('short_description.ru') }}</textarea>
                         @error('short_description.ru')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Azerbaijani Content -->
                <div class="language-content hidden" data-lang="az">
                    <!-- Product Name -->
                    <div class="mb-4">
                        <label for="name_az" class="block text-sm font-medium text-gray-700 mb-1">Product Name (Azerbaijani)</label>
                        <input type="text" id="name_az" name="name[az]" value="{{ old('name.az') }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                        @error('name.az')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Description -->
                    <div class="mb-4">
                        <label for="description_az" class="block text-sm font-medium text-gray-700 mb-1">Description (Azerbaijani)</label>
                        <textarea id="description_az" name="description[az]" rows="6" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('description.az') }}</textarea>
                        @error('description.az')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Short Description -->
                    <div>
                        <label for="short_description_az" class="block text-sm font-medium text-gray-700 mb-1">Short Description (Azerbaijani)</label>
                        <textarea id="short_description_az" name="short_description[az]" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('short_description.az') }}</textarea>
                         @error('short_description.az')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="lg:col-span-1">
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-xl font-semibold text-gray-700 mb-4">Details</h2>
                
                <!-- Price -->
                <div class="mb-4">
                    <label for="price" class="block text-sm font-medium text-gray-700 mb-1">Price</label>
                    <input type="number" step="0.01" id="price" name="price" value="{{ old('price') }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" required>
                    @error('price')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Discount -->
                <div class="mb-4">
                    <label for="discount_type" class="block text-sm font-medium text-gray-700 mb-1">Discount Type</label>
                    <select id="discount_type" name="discount_type" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                        <option value="" {{ old('discount_type') == '' ? 'selected' : '' }}>None</option>
                        <option value="percent" {{ old('discount_type') == 'percent' ? 'selected' : '' }}>Percent (%)</option>
                        <option value="fixed" {{ old('discount_type') == 'fixed' ? 'selected' : '' }}>Fixed Amount</option>
                    </select>
                    @error('discount_type')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="discount_value" class="block text-sm font-medium text-gray-700 mb-1">Discount Value</label>
                    <input type="number" step="0.01" id="discount_value" name="discount_value" value="{{ old('discount_value') }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                    @error('discount_value')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="discount_start" class="block text-sm font-medium text-gray-700 mb-1">Discount Start</label>
                    <input type="datetime-local" id="discount_start" name="discount_start" value="{{ old('discount_start') }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                    @error('discount_start')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="discount_end" class="block text-sm font-medium text-gray-700 mb-1">Discount End</label>
                    <input type="datetime-local" id="discount_end" name="discount_end" value="{{ old('discount_end') }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                    @error('discount_end')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Category -->
                <div class="mb-4">
                    <label for="category_id" class="block text-sm font-medium text-gray-700 mb-1">Category</label>
                    <select id="category_id" name="category_id" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" required>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>{{ $category->getTranslation('name', app()->getLocale()) }}</option>
                        @endforeach
                    </select>
                    @error('category_id')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Vendor -->
                <div class="mb-4">
                    <label for="vendor_id" class="block text-sm font-medium text-gray-700 mb-1">Vendor</label>
                    <select id="vendor_id" name="vendor_id" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                        <option value="">-- None --</option>
                        @foreach($vendors as $vendor)
                            <option value="{{ $vendor->id }}" {{ old('vendor_id') == $vendor->id ? 'selected' : '' }}>{{ $vendor->name }}</option>
                        @endforeach
                    </select>
                    @error('vendor_id')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Stock Quantity -->
                <div class="mb-4">
                    <label for="stock_quantity" class="block text-sm font-medium text-gray-700 mb-1">Stock Quantity</label>
                    <input type="number" id="stock_quantity" name="stock_quantity" value="{{ old('stock_quantity', 0) }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                    @error('stock_quantity')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Product Images (Multiple) -->
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Product Images</label>
                    <input type="file" id="images" name="images[]" multiple accept="image/*" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                    <div id="image-previews" class="flex flex-wrap gap-2 mt-2"></div>
                    <input type="hidden" name="main_image_index" id="main_image_index" value="0">
                    <p class="text-xs text-gray-500 mt-1">Upload multiple images. Select one as the main image for product preview.</p>
                    @error('images')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Tags (Choices.js, robust public pattern) -->
                <div class="mb-4">
                    <label for="tags" class="block text-sm font-medium text-gray-700 mb-2">Tags</label>
                    <select class="js-choices-tags mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md" name="tags[]" multiple>
                        @foreach($tags as $tag)
                            <option value="{{ $tag->id }}" {{ (collect(old('tags'))->contains($tag->id)) ? 'selected' : '' }}>{{ $tag->getTranslation('name', app()->getLocale()) }}</option>
                        @endforeach
                    </select>
                    <p class="text-xs text-gray-500 mt-1">Select all tags that apply to this product.</p>
                    @error('tags')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                @push('head')
                <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/choices.js/public/assets/styles/choices.min.css" />
                @endpush
                @push('scripts')
                <script src="https://cdn.jsdelivr.net/npm/choices.js/public/assets/scripts/choices.min.js"></script>
                <script>
                document.addEventListener('DOMContentLoaded', function() {
                    // Language tab functionality
                    const tabs = document.querySelectorAll('.language-tab');
                    const contents = document.querySelectorAll('.language-content');

                    tabs.forEach(tab => {
                        tab.addEventListener('click', function() {
                            const lang = this.getAttribute('data-lang');
                            
                            // Update tab styles
                            tabs.forEach(t => {
                                t.classList.remove('active', 'border-indigo-500', 'text-indigo-600');
                                t.classList.add('border-transparent', 'text-gray-500');
                            });
                            this.classList.add('active', 'border-indigo-500', 'text-indigo-600');
                            this.classList.remove('border-transparent', 'text-gray-500');
                            
                            // Show/hide content
                            contents.forEach(content => {
                                if (content.getAttribute('data-lang') === lang) {
                                    content.classList.remove('hidden');
                                } else {
                                    content.classList.add('hidden');
                                }
                            });
                        });
                    });

                    // Choices.js initialization
                    document.querySelectorAll('.js-choices-tags').forEach(function(el) {
                        if (!el.classList.contains('choices-initialized')) {
                            new Choices(el, {
                                removeItemButton: true,
                                shouldSort: false,
                                placeholder: true,
                                placeholderValue: el.getAttribute('placeholder') || '',
                                searchPlaceholderValue: 'Search...'
                            });
                            el.classList.add('choices-initialized');
                        }
                    });
                });
                </script>
                @endpush

                <!-- Status -->
                <div class="flex items-center">
                    <input id="is_active" name="is_active" type="checkbox" class="h-4 w-4 text-indigo-600 focus:ring-indigo-500 border-gray-300 rounded" checked>
                    <label for="is_active" class="ml-2 block text-sm text-gray-900">Is Active</label>
                </div>
            </div>

            <div class="mt-6">
                <button type="submit" class="w-full bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-md shadow-sm">
                    Save Product
                </button>
            </div>
        </div>
    </form>
</div>
@endsection 