@extends('layouts.admin')

@section('title', 'Admin - Edit Product')

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-2xl font-semibold text-gray-800 mb-6">{{ __('admin.Edit Product') }}: {{ $product->getTranslation('name', app()->getLocale()) }}</h1>

    <form action="{{ route('admin.products.update', $product) }}" method="POST" enctype="multipart/form-data" class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        @csrf
        @method('PUT')
        
        <!-- Main Content -->
        <div class="lg:col-span-2">
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-xl font-semibold text-gray-700 mb-4">{{ __('Product Information') }}</h2>
                
                <!-- Product Name (Multi-language) -->
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Product Name') }}</label>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-2">
                        <input type="text" name="name[en]" value="{{ old('name.en', $product->getTranslation('name', 'en')) }}" placeholder="English" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" required>
                        <input type="text" name="name[ru]" value="{{ old('name.ru', $product->getTranslation('name', 'ru')) }}" placeholder="Русский" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                        <input type="text" name="name[az]" value="{{ old('name.az', $product->getTranslation('name', 'az')) }}" placeholder="Azərbaycanca" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                    </div>
                    @error('name')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Description (Multi-language) -->
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Description') }}</label>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-2">
                        <textarea name="description[en]" rows="3" placeholder="English" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('description.en', $product->getTranslation('description', 'en')) }}</textarea>
                        <textarea name="description[ru]" rows="3" placeholder="Русский" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('description.ru', $product->getTranslation('description', 'ru')) }}</textarea>
                        <textarea name="description[az]" rows="3" placeholder="Azərbaycanca" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('description.az', $product->getTranslation('description', 'az')) }}</textarea>
                    </div>
                    @error('description')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Short Description (Multi-language) -->
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Short Description') }}</label>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-2">
                        <textarea name="short_description[en]" rows="2" placeholder="English" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('short_description.en', $product->getTranslation('short_description', 'en')) }}</textarea>
                        <textarea name="short_description[ru]" rows="2" placeholder="Русский" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('short_description.ru', $product->getTranslation('short_description', 'ru')) }}</textarea>
                        <textarea name="short_description[az]" rows="2" placeholder="Azərbaycanca" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('short_description.az', $product->getTranslation('short_description', 'az')) }}</textarea>
                    </div>
                    @error('short_description')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="lg:col-span-1">
            <div class="bg-white shadow-md rounded-lg p-6">
                <h2 class="text-xl font-semibold text-gray-700 mb-4">{{ __('Details') }}</h2>
                
                <!-- Price -->
                <div class="mb-4">
                    <label for="price" class="block text-sm font-medium text-gray-700 mb-1">{{ __('Price') }}</label>
                    <input type="number" step="0.01" id="price" name="price" value="{{ old('price', $product->price) }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" required>
                    @error('price')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Discount -->
                <div class="mb-4">
                    <label for="discount_type" class="block text-sm font-medium text-gray-700 mb-1">{{ __('Discount Type') }}</label>
                    <select id="discount_type" name="discount_type" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                        <option value="" {{ old('discount_type', $product->discount_type) == '' ? 'selected' : '' }}>None</option>
                        <option value="percent" {{ old('discount_type', $product->discount_type) == 'percent' ? 'selected' : '' }}>Percent (%)</option>
                        <option value="fixed" {{ old('discount_type', $product->discount_type) == 'fixed' ? 'selected' : '' }}>Fixed Amount</option>
                    </select>
                    @error('discount_type')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="discount_value" class="block text-sm font-medium text-gray-700 mb-1">{{ __('Discount Value') }}</label>
                    <input type="number" step="0.01" id="discount_value" name="discount_value" value="{{ old('discount_value', $product->discount_value) }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                    @error('discount_value')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="discount_start" class="block text-sm font-medium text-gray-700 mb-1">{{ __('Discount Start') }}</label>
                    <input type="datetime-local" id="discount_start" name="discount_start" value="{{ old('discount_start', $product->discount_start ? $product->discount_start->format('Y-m-d\TH:i') : null) }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                    @error('discount_start')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div class="mb-4">
                    <label for="discount_end" class="block text-sm font-medium text-gray-700 mb-1">{{ __('Discount End') }}</label>
                    <input type="datetime-local" id="discount_end" name="discount_end" value="{{ old('discount_end', $product->discount_end ? $product->discount_end->format('Y-m-d\TH:i') : null) }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                    @error('discount_end')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Category -->
                <div class="mb-4">
                    <label for="category_id" class="block text-sm font-medium text-gray-700 mb-1">{{ __('Category') }}</label>
                    <select id="category_id" name="category_id" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" required>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('category_id', $product->category_id) == $category->id ? 'selected' : '' }}>{{ $category->getTranslation('name', app()->getLocale()) }}</option>
                        @endforeach
                    </select>
                    @error('category_id')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Vendor -->
                <div class="mb-4">
                    <label for="vendor_id" class="block text-sm font-medium text-gray-700 mb-1">{{ __('Vendor') }}</label>
                    <select id="vendor_id" name="vendor_id" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                        <option value="">-- None --</option>
                        @foreach($vendors as $vendor)
                            <option value="{{ $vendor->id }}" {{ old('vendor_id', $product->vendor_id) == $vendor->id ? 'selected' : '' }}>{{ $vendor->name }}</option>
                        @endforeach
                    </select>
                    @error('vendor_id')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Tags (Choices.js, robust public pattern) -->
                <div class="mb-4">
                    <label for="tags" class="block text-sm font-medium text-gray-700 mb-2">{{ __('Tags') }}</label>
                    <select class="js-choices-tags mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md" name="tags[]" multiple>
                        @foreach($tags as $tag)
                            <option value="{{ $tag->id }}" {{ (collect(old('tags', $product->tags->pluck('id')))->contains($tag->id)) ? 'selected' : '' }}>{{ $tag->getTranslation('name', app()->getLocale()) }}</option>
                        @endforeach
                    </select>
                    <p class="text-xs text-gray-500 mt-1">{{ __('Select all tags that apply to this product.') }}</p>
                    @error('tags')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                @push('head')
                <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/choices.js/public/assets/styles/choices.min.css" />
                @endpush
                @push('scripts')
                <script src="https://cdn.jsdelivr.net/npm/choices.js/public/assets/scripts/choices.min.js"></script>
                <script>
                document.addEventListener('DOMContentLoaded', function() {
                    document.querySelectorAll('.js-choices-tags').forEach(function(el) {
                        if (!el.classList.contains('choices-initialized')) {
                            new Choices(el, {
                                removeItemButton: true,
                                shouldSort: false,
                                placeholder: true,
                                placeholderValue: el.getAttribute('placeholder') || '',
                                searchPlaceholderValue: 'Search...'
                            });
                            el.classList.add('choices-initialized');
                        }
                    });
                });
                </script>
                @endpush

                <!-- Stock Quantity -->
                <div class="mb-4">
                    <label for="stock_quantity" class="block text-sm font-medium text-gray-700 mb-1">{{ __('Stock Quantity') }}</label>
                    <input type="number" id="stock_quantity" name="stock_quantity" value="{{ old('stock_quantity', $product->stock_quantity) }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                    @error('stock_quantity')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Product Images (Multiple) -->
                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-1">{{ __('Product Images') }}</label>
                    <div class="flex flex-wrap gap-2 mb-2">
                        @foreach($product->images as $img)
                            <div class="relative flex flex-col items-center" style="width: 80px;">
                                <img src="{{ asset('storage/' . $img->image_path) }}" class="w-16 h-16 object-cover rounded border">
                                <input type="radio" name="main_image_id" value="{{ $img->id }}" class="mt-1" {{ $img->is_main ? 'checked' : '' }}>
                                <label class="text-xs text-gray-600 mt-1">{{ __('Main') }}</label>
                                <label class="absolute top-0 right-0 cursor-pointer">
                                    <input type="checkbox" name="delete_images[]" value="{{ $img->id }}" class="hidden delete-image-checkbox">
                                    <span class="inline-block bg-red-500 text-white rounded-full px-1 text-xs">&times;</span>
                                </label>
                            </div>
                        @endforeach
                    </div>
                    <input type="file" id="images" name="images[]" multiple accept="image/*" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                    <div id="image-previews" class="flex flex-wrap gap-2 mt-2"></div>
                    <input type="hidden" name="main_new_image_index" id="main_new_image_index" value="">
                    <p class="text-xs text-gray-500 mt-1">{{ __('Upload new images, set one as main, or remove existing images.') }}</p>
                    @error('images')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Status -->
                <div class="flex items-center">
                    <input id="is_active" name="is_active" type="checkbox" class="h-4 w-4 text-indigo-600 focus:ring-indigo-500 border-gray-300 rounded" {{ old('is_active', $product->is_active) ? 'checked' : '' }}>
                    <label for="is_active" class="ml-2 block text-sm text-gray-900">{{ __('Is Active') }}</label>
                </div>
            </div>

            <div class="mt-6">
                <button type="submit" class="w-full bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-md shadow-sm">
                    {{ __('Update Product') }}
                </button>
            </div>
        </div>
    </form>
</div>
@endsection 