@extends('layouts.admin')

@section('title', 'Admin - Edit Vendor')

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-2xl font-semibold text-gray-800 mb-6">Edit Vendor: {{ $vendor->name }}</h1>

    <div class="max-w-2xl bg-white shadow-md rounded-lg p-8">
        <form action="{{ route('admin.vendors.update', $vendor) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="mb-6">
                <label class="block text-sm font-medium text-gray-700 mb-1">Vendor Name</label>
                <div class="border-b border-gray-200 mb-2">
                    <nav class="-mb-px flex space-x-8" aria-label="Tabs">
                        <button type="button" class="language-tab border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-2 px-1 border-b-2 font-medium text-sm active" data-lang="en">English</button>
                        <button type="button" class="language-tab border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-2 px-1 border-b-2 font-medium text-sm" data-lang="ru">Русский</button>
                        <button type="button" class="language-tab border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 whitespace-nowrap py-2 px-1 border-b-2 font-medium text-sm" data-lang="az">Azərbaycan</button>
                    </nav>
                </div>
                <div class="language-content" data-lang="en">
                    <input type="text" id="name_en" name="name[en]" value="{{ old('name.en', $vendor->getTranslation('name', 'en')) }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" required placeholder="Vendor Name (English)">
                    @error('name.en')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div class="language-content hidden" data-lang="ru">
                    <input type="text" id="name_ru" name="name[ru]" value="{{ old('name.ru', $vendor->getTranslation('name', 'ru')) }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" placeholder="Vendor Name (Russian)">
                    @error('name.ru')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
                <div class="language-content hidden" data-lang="az">
                    <input type="text" id="name_az" name="name[az]" value="{{ old('name.az', $vendor->getTranslation('name', 'az')) }}" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" placeholder="Vendor Name (Azerbaijani)">
                    @error('name.az')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>
            <div class="mb-6">
                <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                <textarea id="description" name="description" rows="4" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">{{ old('description', $vendor->description) }}</textarea>
                @error('description')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>
            <div class="mb-6">
                <label for="logo" class="block text-sm font-medium text-gray-700 mb-1">Logo</label>
                <input type="file" id="logo" name="logo" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                @error('logo')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
                @if($vendor->logo)
                    <div class="mt-4">
                        <p class="text-sm text-gray-500 mb-2">Current Logo:</p>
                        <img src="{{ asset('storage/' . $vendor->logo) }}" alt="Current Logo" class="h-12 w-24 object-contain">
                        <div class="mt-2">
                            <label class="inline-flex items-center">
                                <input type="checkbox" name="remove_logo" value="1" class="form-checkbox">
                                <span class="ml-2 text-sm text-gray-600">Remove logo</span>
                            </label>
                        </div>
                    </div>
                @endif
            </div>
            <div class="flex justify-end">
                <a href="{{ route('admin.vendors.index') }}" class="bg-gray-200 hover:bg-gray-300 text-black font-bold py-2 px-4 rounded-md shadow-sm mr-2">
                    Cancel
                </a>
                <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-md shadow-sm">
                    Update Vendor
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const tabs = document.querySelectorAll('.language-tab');
    const contents = document.querySelectorAll('.language-content');
    tabs.forEach(tab => {
        tab.addEventListener('click', function() {
            const lang = this.getAttribute('data-lang');
            tabs.forEach(t => {
                t.classList.remove('active', 'border-indigo-500', 'text-indigo-600');
                t.classList.add('border-transparent', 'text-gray-500');
            });
            this.classList.add('active', 'border-indigo-500', 'text-indigo-600');
            this.classList.remove('border-transparent', 'text-gray-500');
            contents.forEach(content => {
                if (content.getAttribute('data-lang') === lang) {
                    content.classList.remove('hidden');
                } else {
                    content.classList.add('hidden');
                }
            });
        });
    });
});
</script>
@endpush 