@extends('layouts.admin')

@section('title', 'Admin - Vendors')

@section('content')
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-semibold text-gray-800">{{ __('admin.vendors') }}</h1>
        <a href="{{ route('admin.vendors.create') }}" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
            {{ __('admin.add_new_vendor') }}
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
            <p>{{ session('success') }}</p>
        </div>
    @endif

    <div class="bg-white shadow-md rounded-lg overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.logo') }}</th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.name') }}</th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.description') }}</th>
                        <th class="py-3 px-6 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('admin.actions') }}</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    @forelse($vendors as $vendor)
                        <tr class="hover:bg-gray-50" data-vendor-id="{{ $vendor->id }}">
                            <td class="py-4 px-6 whitespace-nowrap">
                                @if($vendor->logo)
                                    <img src="{{ asset('storage/' . $vendor->logo) }}" alt="{{ $vendor->name }}" class="h-12 w-24 object-contain">
                                @else
                                    <span class="text-sm text-gray-500">{{ __('admin.no_logo') }}</span>
                                @endif
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm font-medium text-gray-900">
                                {{ $vendor->name }}
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm text-gray-700">
                                {{ $vendor->description }}
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.vendors.edit', $vendor) }}" class="text-indigo-600 hover:text-indigo-900 mr-4">{{ __('admin.edit') }}</a>
                                <button type="button" class="text-red-600 hover:text-red-900 delete-vendor-btn" data-url="{{ route('admin.vendors.destroy', $vendor) }}">{{ __('admin.delete') }}</button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="py-4 px-6 text-center text-gray-500">
                                {{ __('admin.no_vendors_found') }}
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection 

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-dismiss server-side success alert
    const serverAlert = document.querySelector('.bg-green-100[role="alert"]');
    if (serverAlert) {
        setTimeout(() => serverAlert.remove(), 500);
    }

    document.querySelectorAll('.delete-vendor-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            if (!confirm('{{ __('admin.are_you_sure_you_want_to_delete_this_vendor') }}')) return;
            const url = this.getAttribute('data-url');
            const row = this.closest('tr');
            fetch(url, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json',
                },
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    row.remove();
                    showVendorSuccess('{{ __('admin.vendor_deleted_successfully') }}');
                } else {
                    alert(data.message || '{{ __('admin.failed_to_delete_vendor') }}');
                }
            })
            .catch(() => alert('{{ __('admin.failed_to_delete_vendor') }}'));
        });
    });

    function showVendorSuccess(msg) {
        let alert = document.createElement('div');
        alert.className = 'bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4';
        alert.role = 'alert';
        alert.innerHTML = `<p>${msg}</p>`;
        document.querySelector('.container').prepend(alert);
        setTimeout(() => alert.remove(), 500);
    }
});
</script> 