@extends('layouts.app')

@section('content')
<div class="bg-white dark:bg-gray-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <h1 class="text-3xl font-bold tracking-tight text-gray-900 dark:text-white mb-8">{{ __('shopping_cart') }}</h1>
        
        @if(empty($cartItems))
            <div class="text-center py-12">
                <h2 class="text-2xl font-bold text-gray-900 dark:text-white">{{ __('your_cart_is_empty') }}</h2>
                <p class="mt-2 text-gray-500 dark:text-gray-400">Start shopping to add items to your cart.</p>
                <a href="{{ route('products.index') }}" class="mt-4 inline-block bg-indigo-600 text-white px-6 py-3 rounded-md hover:bg-indigo-700">
                    {{ __('continue_shopping') }}
                </a>
            </div>
            
            @if(!empty($suggestedProducts))
            <div class="mt-8">
                <h2 class="text-2xl font-bold text-gray-900 dark:text-white">{{ __('general.new_arrivals') }}</h2>
                <div class="mt-6 grid grid-cols-1 gap-y-10 gap-x-6 sm:grid-cols-2 lg:grid-cols-4 xl:gap-x-8">
                    @foreach($suggestedProducts as $product)
                        <div class="group relative">
                            <div class="min-h-80 aspect-w-1 aspect-h-1 w-full overflow-hidden rounded-md bg-gray-200 group-hover:opacity-75 lg:aspect-none lg:h-80">
                                <img src="{{ $product->image ? asset('storage/' . $product->image) : 'https://via.placeholder.com/400' }}" alt="{{ $product->name }}" class="h-full w-full object-cover object-center lg:h-full lg:w-full">
                            </div>
                            <div class="mt-4 flex justify-between">
                                <div>
                                    <h3 class="text-sm text-gray-700 dark:text-gray-200">
                                        <a href="{{ route('products.show', $product) }}">
                                            <span aria-hidden="true" class="absolute inset-0"></span>
                                            {{ $product->name }}
                                        </a>
                                    </h3>
                                </div>
                                @php
                                    $currency = session('currency', 'USD');
                                    $price = $product->getPriceInCurrency($currency);
                                    $finalPrice = $product->getFinalPriceInCurrency($currency);
                                    $symbol = $product->getCurrencySymbol($currency);
                                @endphp
                                <p class="text-sm font-medium text-gray-900 dark:text-white">
                                    @if($product->isDiscounted())
                                        <span class="line-through text-gray-500">{{ $symbol }}{{ number_format($price, 2) }}</span>
                                        <span class="text-red-600 font-bold">{{ $symbol }}{{ number_format($finalPrice, 2) }}</span>
                                    @else
                                        {{ $symbol }}{{ number_format($price, 2) }}
                                    @endif
                                </p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            @endif
        @else
            <div class="lg:grid lg:grid-cols-12 lg:gap-x-12 lg:items-start">
                <div class="lg:col-span-7">
                    <div class="border-t border-gray-200 dark:border-gray-700 divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach($cartItems as $item)
                            <div class="py-6 flex">
                                <div class="flex-shrink-0 w-24 h-24">
                                    <img src="{{ $item['product']->image ? asset('storage/' . $item['product']->image) : 'https://via.placeholder.com/400' }}" alt="{{ $item['product']->name }}" class="w-full h-full object-center object-cover rounded-md">
                                </div>
                                <div class="ml-4 flex flex-1 flex-col justify-between sm:ml-6">
                                    <div class="relative pr-9 sm:grid sm:grid-cols-2 sm:gap-x-6 sm:pr-0">
                                        <div>
                                            <div class="flex justify-between">
                                                <h3 class="text-sm">
                                                    <a href="{{ route('products.show', $item['product']) }}" class="font-medium text-gray-700 dark:text-gray-200 hover:text-gray-800">{{ $item['product']->name }}</a>
                                                </h3>
                                            </div>
                                            @php
                                                $currency = session('currency', 'USD');
                                                $price = $item['product']->getPriceInCurrency($currency);
                                                $finalPrice = $item['product']->getFinalPriceInCurrency($currency);
                                                $symbol = $item['product']->getCurrencySymbol($currency);
                                            @endphp
                                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">
                                                @if($item['product']->isDiscounted())
                                                    <span class="line-through text-gray-500">{{ $symbol }}{{ number_format($price, 2) }}</span>
                                                    <span class="text-red-600 font-bold">{{ $symbol }}{{ number_format($finalPrice, 2) }}</span>
                                                @else
                                                    {{ $symbol }}{{ number_format($price, 2) }}
                                                @endif
                                            </p>
                                        </div>
                                        <div class="mt-4 sm:mt-0 sm:pr-9">
                                            <label for="quantity-{{ $item['product']->id }}" class="sr-only">Quantity, {{ $item['product']->name }}</label>
                                            <form method="POST" action="{{ route('cart.update') }}" class="max-w-xs flex items-center space-x-2 cart-qty-form" data-product-id="{{ $item['product']->id }}">
                                                @csrf
                                                <input type="hidden" name="product_id" value="{{ $item['product']->id }}">
                                                <button type="button" class="decrement-qty px-2 py-1 rounded bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-200 hover:bg-gray-300 dark:hover:bg-gray-600" aria-label="Decrease quantity">
                                                    -
                                                </button>
                                                <input type="number" name="quantity" id="quantity-{{ $item['product']->id }}" value="{{ $item['quantity'] }}" min="1" max="{{ $item['product']->stock_quantity }}" class="w-20 rounded-md border border-gray-300 py-1.5 px-2 text-base leading-5 focus:border-indigo-500 focus:outline-none focus:ring-1 focus:ring-indigo-500 sm:text-sm dark:bg-gray-700 dark:border-gray-600 dark:text-white text-center cart-qty-input" autocomplete="off">
                                                <button type="button" class="increment-qty px-2 py-1 rounded bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-200 hover:bg-gray-300 dark:hover:bg-gray-600" aria-label="Increase quantity">
                                                    +
                                                </button>
                                            </form>
                                            <div class="absolute top-0 right-0">
                                                <form method="POST" action="{{ route('cart.remove') }}">
                                                    @csrf
                                                    <input type="hidden" name="product_id" value="{{ $item['product']->id }}">
                                                    <button type="submit" class="-m-2 inline-flex p-2 text-gray-400 hover:text-gray-500">
                                                        <span class="sr-only">Remove</span>
                                                        <svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                                            <path d="M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" />
                                                        </svg>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="mt-4 flex text-sm text-gray-700 dark:text-gray-300 space-x-2">
                                        <span>Subtotal: <span id="cart-subtotal-{{ $item['product']->id }}">{{ $symbol }}{{ number_format($item['subtotal'], 2) }}</span></span>
                                    </p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <!-- Order summary -->
                @php
                    $currency = session('currency', 'USD');
                    $symbol = get_currency_symbol($currency);
                @endphp
                <section aria-labelledby="summary-heading" class="mt-16 rounded-lg bg-gray-50 dark:bg-gray-800 px-4 py-6 sm:p-6 lg:col-span-5 lg:mt-0 lg:p-8">
                    <h2 id="summary-heading" class="text-lg font-medium text-gray-900 dark:text-white">Order summary</h2>
                    <dl class="mt-6 space-y-4">
                        <div class="flex items-center justify-between">
                            <dt class="text-sm text-gray-600 dark:text-gray-400">Subtotal</dt>
                            <dd class="text-sm font-medium text-gray-900 dark:text-white cart-total-amount">{{ $symbol }}{{ number_format($total, 2) }}</dd>
                        </div>
                        <div class="flex items-center justify-between border-t border-gray-200 dark:border-gray-700 pt-4">
                            <dt class="text-base font-medium text-gray-900 dark:text-white">Order total</dt>
                            <dd class="text-base font-medium text-gray-900 dark:text-white cart-total-amount">{{ $symbol }}{{ number_format($total, 2) }}</dd>
                        </div>
                    </dl>
                    <div class="mt-6">
                        <a href="{{ route('checkout.index') }}" class="w-full bg-indigo-600 border border-transparent rounded-md shadow-sm py-3 px-4 text-base font-medium text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-50 focus:ring-indigo-500">
                            Proceed to checkout
                        </a>
                    </div>
                    <div class="mt-6 flex justify-center text-center text-sm text-gray-500 dark:text-gray-400">
                        <p>
                            {{ __('or') }}
                            <a href="{{ route('products.index') }}" class="font-medium text-indigo-600 hover:text-indigo-500">
                                {{ __('continue_shopping') }}
                            </a>
                        </p>
                    </div>
                </section>
            </div>
        @endif
    </div>
</div>
@endsection
