@props(['active'])

@php
$classes = ($active ?? false)
            ? 'inline-flex items-center w-full text-sm font-semibold text-white transition-colors duration-150'
            : 'inline-flex items-center w-full text-sm font-semibold text-gray-400 transition-colors duration-150 hover:text-gray-200';
@endphp

<a {{ $attributes->merge(['class' => $classes]) }}>
    @if($active ?? false)
        <span class="absolute inset-y-0 left-0 w-1 bg-indigo-600 rounded-tr-lg rounded-br-lg" aria-hidden="true"></span>
    @endif
    {{ $slot }}
</a> 