<div class="relative" x-data="{ open: false }">
    <button @click="open = !open" class="flex items-center text-sm font-medium text-gray-700 dark:text-gray-200 hover:text-indigo-600">
        <span class="mr-1">{{ session('currency', 'USD') }}</span>
        <svg class="ml-1 h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
        </svg>
    </button>
    
    <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-32 bg-white dark:bg-gray-800 rounded-md shadow-lg py-1 z-50">
        <a href="{{ request()->fullUrlWithQuery(['currency' => 'USD']) }}" 
           class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700 {{ session('currency', 'USD') === 'USD' ? 'bg-indigo-50 dark:bg-indigo-900' : '' }}">
            $ USD
        </a>
        <a href="{{ request()->fullUrlWithQuery(['currency' => 'AZN']) }}" 
           class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700 {{ session('currency', 'USD') === 'AZN' ? 'bg-indigo-50 dark:bg-indigo-900' : '' }}">
            ₼ AZN
        </a>
    </div>
</div> 