@extends('layouts.app')

@section('title', __('my_favourites'))

@section('content')
<div class="container mx-auto px-4 py-8">
    <h1 class="text-2xl font-semibold text-gray-800 mb-6">{{ __('my_favourites') }}</h1>
    <div id="favourites-list">
    @if($favourites->count())
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach($favourites as $fav)
                @if($fav->product)
                <div class="bg-white rounded-lg shadow p-4 flex flex-col items-center favourite-card" data-product-id="{{ $fav->product->id }}">
                    <img src="{{ $fav->product->image ? asset('storage/' . $fav->product->image) : 'https://via.placeholder.com/150' }}" alt="{{ $fav->product->name }}" class="w-32 h-32 object-cover rounded mb-2">
                    <div class="font-semibold text-lg text-center">{{ $fav->product->name }}</div>
                    <div class="text-gray-500 mb-2">
                        @if($fav->product->isDiscounted())
                            <span class="line-through text-gray-500">${{ number_format($fav->product->price, 2) }}</span>
                            <span class="text-red-600 font-bold">${{ number_format($fav->product->final_price, 2) }}</span>
                        @else
                            ${{ number_format($fav->product->price, 2) }}
                        @endif
                    </div>
                    <button type="button" class="text-red-500 hover:text-red-700 remove-favourite-btn">{{ __('remove') }}</button>
                </div>
                @endif
            @endforeach
        </div>
    @else
        <div class="text-center text-gray-500 py-12" id="no-favourites-msg">{{ __('no_favourites') }}</div>
    @endif
    </div>
</div>
@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    function handleRemoveFavourite(e) {
        if (!e.target.classList.contains('remove-favourite-btn')) return;
        const card = e.target.closest('.favourite-card');
        const productId = card.getAttribute('data-product-id');
        fetch("{{ route('favourites.destroy') }}", {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
                'Accept': 'application/json',
            },
            body: JSON.stringify({ product_id: productId })
        })
        .then(r => r.json())
        .then(data => {
            if (data.success) {
                card.remove();
                if (typeof updateFavouritesCount === 'function') updateFavouritesCount();
                if (document.querySelectorAll('.favourite-card').length === 0) {
                    document.getElementById('favourites-list').innerHTML = '<div class="text-center text-gray-500 py-12" id="no-favourites-msg">You have no favourite products yet.</div>';
                }
            }
        });
    }
    document.getElementById('favourites-list').addEventListener('click', handleRemoveFavourite);
});
</script>
@endpush 