<x-app-layout>
    <div class="bg-white dark:bg-gray-900">
        <!-- Hero Section -->
        <div class="relative bg-gray-800 overflow-hidden">
            <div class="max-w-7xl mx-auto">
                <div class="relative z-10 pb-8 bg-gray-800 sm:pb-16 md:pb-20 lg:max-w-2xl lg:w-full lg:pb-28 xl:pb-32">
                    <svg class="hidden lg:block absolute right-0 inset-y-0 h-full w-48 text-gray-800 transform translate-x-1/2" fill="currentColor" viewBox="0 0 100 100" preserveAspectRatio="none" aria-hidden="true">
                        <polygon points="50,0 100,0 50,100 0,100" />
                    </svg>

                    <div class="relative pt-6 px-4 sm:px-6 lg:px-8"></div>

                    <main class="mt-10 mx-auto max-w-7xl px-4 sm:mt-12 sm:px-6 md:mt-16 lg:mt-20 lg:px-8 xl:mt-28">
                        <div class="sm:text-center lg:text-left">
                            <h1 class="text-4xl tracking-tight font-extrabold text-white sm:text-5xl md:text-6xl">
                                <span class="block xl:inline">{{ __('general.the_best_products') }}</span>
                                <span class="block text-indigo-400 xl:inline">{{ __('general.for_your_needs') }}</span>
                            </h1>
                            <p class="mt-3 text-base text-gray-300 sm:mt-5 sm:text-lg sm:max-w-xl sm:mx-auto md:mt-5 md:text-xl lg:mx-0">
                                {{ __('general.discover_amazing_products_at_great_prices') }}
                            </p>
                            
                            <!-- Hero Search Bar -->
                            <div class="mt-8 sm:mt-10 max-w-lg mx-auto lg:mx-0">
                                <form action="{{ route('products.index') }}" method="GET" class="relative">
                                    <div class="relative">
                                        <input type="text" 
                                               name="search" 
                                               placeholder="{{ __('general.search_for_products') }}" 
                                               class="w-full pl-12 pr-4 py-4 text-lg border-0 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 focus:ring-offset-gray-800 shadow-lg">
                                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                            <svg class="h-6 w-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                            </svg>
                                        </div>
                                        <button type="submit" class="absolute inset-y-0 right-0 pr-4 flex items-center">
                                            <span class="bg-indigo-600 text-white px-6 py-2 rounded-md hover:bg-indigo-700 transition-colors">
                                                {{ __('general.search') }}
                                            </span>
                                        </button>
                                    </div>
                                </form>
                                <p class="mt-2 text-sm text-gray-400 text-center lg:text-left">
                                    {{ __('general.popular_searches') }}: <a href="{{ route('products.index', ['search' => 'electronics']) }}" class="text-indigo-400 hover:text-indigo-300">{{ __('general.electronics') }}</a>, 
                                    <a href="{{ route('products.index', ['search' => 'clothing']) }}" class="text-indigo-400 hover:text-indigo-300">{{ __('general.clothing') }}</a>, 
                                    <a href="{{ route('products.index', ['search' => 'books']) }}" class="text-indigo-400 hover:text-indigo-300">{{ __('general.books') }}</a>
                                </p>
                            </div>
                            
                            <div class="mt-8 sm:mt-10 sm:flex sm:justify-center lg:justify-start">
                                <div class="rounded-md shadow">
                                    <a href="{{ route('products.index') }}" class="w-full flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 md:py-4 md:text-lg md:px-10">
                                        {{ __('general.browse_all_products') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    </main>
                </div>
            </div>
            <div class="lg:absolute lg:inset-y-0 lg:right-0 lg:w-1/2">
                <img class="h-56 w-full object-cover sm:h-72 md:h-96 lg:w-full lg:h-full" src="https://images.unsplash.com/photo-1551434678-e076c223a692?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=2850&q=80" alt="">
            </div>
        </div>

        <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <!-- Featured Products Section -->
            <section id="featured-products">
                <div class="flex justify-between items-center mb-8">
                    <h2 class="text-3xl font-extrabold text-gray-900 dark:text-white tracking-tight">{{ __('general.featured_products') }}</h2>
                    <a href="{{ route('products.index') }}" class="text-indigo-600 hover:text-indigo-500 font-semibold">
                        {{ __('general.view_all') }} &rarr;
                    </a>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-x-6 gap-y-10">
                    @forelse($featuredProducts as $product)
                        <div class="group relative bg-white border border-gray-200 rounded-lg flex flex-col overflow-hidden">
                            <a href="{{ route('products.show', $product) }}" class="aspect-w-3 aspect-h-4 bg-gray-200 group-hover:opacity-75 sm:aspect-none sm:h-96">
                                <img src="{{ $product->image ? asset('storage/' . $product->image) : 'https://via.placeholder.com/400' }}"
                                     alt="{{ $product->name }}"
                                     class="w-full h-full object-center object-cover sm:w-full sm:h-full">
                            </a>
                            <div class="flex-1 p-4 space-y-2 flex flex-col">
                                <h3 class="text-sm font-medium text-gray-900">
                                    <a href="{{ route('products.show', $product) }}">
                                        <span aria-hidden="true" class="absolute inset-0"></span>
                                        {{ $product->name }}
                                    </a>
                                </h3>
                                <p class="text-sm text-gray-500">{{ $product->category->name ?? 'Uncategorized' }}</p>
                                <div class="flex-1 flex flex-col justify-end">
                                    @php
                                        $currency = session('currency', 'USD');
                                        $price = $product->getPriceInCurrency($currency);
                                        $finalPrice = $product->getFinalPriceInCurrency($currency);
                                        $symbol = $product->getCurrencySymbol($currency);
                                    @endphp
                                    <p class="text-base font-medium text-gray-900">
                                        @if($product->isDiscounted())
                                            <span class="line-through text-gray-500">{{ $symbol }}{{ number_format($price, 2) }}</span>
                                            <span class="text-red-600 font-bold">{{ $symbol }}{{ number_format($finalPrice, 2) }}</span>
                                        @else
                                            {{ $symbol }}{{ number_format($price, 2) }}
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                    @empty
                        <p class="text-gray-500 col-span-4">{{ __('general.no_featured_products') }}</p>
                    @endforelse
                </div>
            </section>

            <!-- Categories Section -->
            <section class="mt-16">
                <h2 class="text-3xl font-extrabold text-gray-900 tracking-tight mb-8">{{ __('general.shop_by_category') }}</h2>
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-6 text-center">
                     @forelse($categories as $category)
                        <a href="{{ route('products.category', $category) }}" class="group">
                            <div class="w-full aspect-w-1 aspect-h-1 rounded-lg overflow-hidden bg-gray-200">
                                <img src="{{ $category->image ? asset('storage/' . $category->image) : 'https://via.placeholder.com/400x400.png?text=' . urlencode($category->name) }}"
                                     alt="{{$category->name}}"
                                     class="w-full h-full object-center object-cover group-hover:opacity-75">
                            </div>
                            <h3 class="mt-4 text-sm font-medium text-gray-700">{{ $category->name }}</h3>
                            <p class="mt-1 text-sm text-gray-500">{{ $category->products_count }} products</p>
                        </a>
                    @empty
                        <p class="text-gray-500 col-span-full">{{ __('general.no_categories') }}</p>
                    @endforelse
                </div>
            </section>

            <!-- Latest Products Section -->
            <section class="mt-16">
                <h2 class="text-3xl font-extrabold text-gray-900 tracking-tight mb-8">{{ __('general.new_arrivals') }}</h2>
                 <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-x-6 gap-y-10">
                    @forelse($latestProducts as $product)
                        <div class="group relative bg-white border border-gray-200 rounded-lg flex flex-col overflow-hidden">
                            <a href="{{ route('products.show', $product) }}" class="aspect-w-3 aspect-h-4 bg-gray-200 group-hover:opacity-75 sm:aspect-none sm:h-96">
                                <img src="{{ $product->image ? asset('storage/' . $product->image) : 'https://via.placeholder.com/400' }}"
                                     alt="{{ $product->name }}"
                                     class="w-full h-full object-center object-cover sm:w-full sm:h-full">
                            </a>
                            <div class="flex-1 p-4 space-y-2 flex flex-col">
                                <h3 class="text-sm font-medium text-gray-900">
                                    <a href="{{ route('products.show', $product) }}">
                                        <span aria-hidden="true" class="absolute inset-0"></span>
                                        {{ $product->name }}
                                    </a>
                                </h3>
                                <p class="text-sm text-gray-500">{{ $product->category->name ?? 'Uncategorized' }}</p>
                                <div class="flex-1 flex flex-col justify-end">
                                    @php
                                        $currency = session('currency', 'USD');
                                        $price = $product->getPriceInCurrency($currency);
                                        $finalPrice = $product->getFinalPriceInCurrency($currency);
                                        $symbol = $product->getCurrencySymbol($currency);
                                    @endphp
                                    <p class="text-base font-medium text-gray-900">
                                        @if($product->isDiscounted())
                                            <span class="line-through text-gray-500">{{ $symbol }}{{ number_format($price, 2) }}</span>
                                            <span class="text-red-600 font-bold">{{ $symbol }}{{ number_format($finalPrice, 2) }}</span>
                                        @else
                                            {{ $symbol }}{{ number_format($price, 2) }}
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                    @empty
                        <p class="text-gray-500 col-span-4">{{ __('general.no_new_products') }}</p>
                    @endforelse
                </div>
            </section>

        </div>
    </div>
</x-app-layout>
