<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Admin Panel') - {{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles
</head>
<body class="font-sans antialiased">
    <div
        x-data="{
            theme: localStorage.getItem('theme') || (window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light'),
            setTheme(theme) {
                this.theme = theme;
                localStorage.setItem('theme', theme);
                if (theme === 'dark') {
                    document.documentElement.classList.add('dark');
                } else {
                    document.documentElement.classList.remove('dark');
                }
            }
        }"
        x-init="
            if (theme === 'dark') document.documentElement.classList.add('dark');
            $watch('theme', val => {
                localStorage.setItem('theme', val);
                if (val === 'dark') {
                    document.documentElement.classList.add('dark');
                } else {
                    document.documentElement.classList.remove('dark');
                }
            });
        "
    >
        <div class="flex h-screen bg-gray-100 dark:bg-gray-900">
            <!-- Sidebar and mobile sidebar Alpine context -->
            <div x-data="{ sidebarOpen: false }" class="flex flex-1 w-full">
                <!-- Sidebar -->
                <aside class="z-30 flex-shrink-0 hidden w-64 overflow-y-auto bg-white dark:bg-gray-800 lg:block">
                    @include('layouts.partials.admin-sidebar')
                </aside>

                <!-- Mobile sidebar -->
                <div x-show="sidebarOpen" class="lg:hidden" x-transition:enter="transition ease-in-out duration-150" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in-out duration-150" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" @click="sidebarOpen = false" class="fixed inset-0 z-10 flex items-end bg-black bg-opacity-50 sm:items-center sm:justify-center"></div>
                <aside class="fixed inset-y-0 z-20 flex-shrink-0 w-64 mt-16 overflow-y-auto bg-white dark:bg-gray-800 md:hidden" x-show="sidebarOpen" x-transition:enter="transition ease-in-out duration-150" x-transition:enter-start="opacity-0 transform -translate-x-20" x-transition:enter-end="opacity-100" @click.away="sidebarOpen = false" @keydown.escape="sidebarOpen = false">
                    @include('layouts.partials.admin-sidebar')
                </aside>

                <div class="flex flex-col flex-1 w-full">
                    @include('layouts.partials.admin-header')
                    <main class="h-full overflow-y-auto">
                        <div class="container px-6 mx-auto grid">
                            <h2 class="my-6 text-2xl font-semibold text-gray-700 dark:text-gray-200">
                                @yield('title')
                            </h2>
                            @yield('content')
                        </div>
                    </main>
                </div>
            </div>
        </div>
    </div>
    @stack('modals')
    <script>
        window.deferLoadingAlpine = function (callback) {
            window.addEventListener('alpine:initialized', callback);
        };
    </script>
    @livewireScripts
    @stack('scripts')
</body>
</html> 