<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" x-data="{
    theme: localStorage.getItem('theme') || (window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light')
}" x-init="
    if (theme === 'dark') document.documentElement.classList.add('dark');
    $watch('theme', val => {
        localStorage.setItem('theme', val);
        if (val === 'dark') {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    });
">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'E-Commerce') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        <!-- Choices.js CSS -->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/choices.js/public/assets/styles/choices.min.css" />
        @stack('head')
    </head>
    <body class="bg-gray-100 dark:bg-gray-900 min-h-screen flex flex-col">
        <!-- Navbar -->
        <nav class="bg-white dark:bg-gray-800 shadow sticky top-0 z-50">
            <div class="container mx-auto px-4 py-3">
                <div class="flex items-center justify-between">
                <div class="flex items-center gap-4">
                    <a href="{{ route('home') }}" class="flex items-center gap-2 font-bold text-xl text-indigo-600 dark:text-indigo-400">
                        <x-application-logo class="h-8 w-8" />
                        E-Commerce
                    </a>
                    <a href="{{ route('products.index') }}" class="ml-6 text-gray-700 dark:text-gray-200 hover:text-indigo-600">{{ __('general.all_products') }}</a>
                </div>
                    
                    <!-- Search Bar -->
                    <div class="flex-1 max-w-lg mx-8">
                        <form action="{{ route('products.index') }}" method="GET" class="relative">
                            <div class="relative">
                                <input type="text" 
                                       name="search" 
                                       value="{{ request('search') }}"
                                       placeholder="Search products..." 
                                       class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:placeholder-gray-400">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                    </svg>
                                </div>
                                <button type="submit" class="absolute inset-y-0 right-0 pr-3 flex items-center">
                                    <svg class="h-5 w-5 text-gray-400 hover:text-indigo-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                    </svg>
                                </button>
                            </div>
                        </form>
                    </div>
                    
                <div class="flex items-center gap-4">
                    <!-- Currency Switcher -->
                    <x-currency-switcher />
                    <!-- Language Switcher -->
                    <x-language-switcher />
                    <!-- Theme Switcher -->
                    <x-theme-switcher />
                    
                    @auth
                        @if(!Auth::user()->isAdmin())
                            <a href="{{ route('cart.index') }}" class="relative text-gray-700 dark:text-gray-200 hover:text-indigo-600">
                                <x-cart-icon />
                                <span id="cart-count" class="absolute -top-2 -right-2 bg-red-500 text-white text-xs rounded-full px-1.5 py-0.5" style="display: none;">0</span>
                            </a>
                            <a href="{{ route('favourites.index') }}" class="relative text-gray-700 dark:text-gray-200 hover:text-pink-500">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-6 h-6">
                                        <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41 0.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z" stroke="currentColor" stroke-width="2" fill="none"/>
                                </svg>
                                <span id="favourites-count" class="absolute -top-2 -right-2 bg-pink-500 text-white text-xs rounded-full px-1.5 py-0.5" style="display: none;">0</span>
                            </a>
                        @endif
                        <x-dropdown align="right" width="48">
                            <x-slot name="trigger">
                                <button class="flex items-center text-sm font-medium text-gray-700 dark:text-gray-200 hover:text-indigo-600">
                                    <span>{{ Auth::user()->name }}</span>
                                    <svg class="ml-1 h-4 w-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" /></svg>
                                </button>
                            </x-slot>
                            <x-slot name="content">
                                @if(Auth::user()->isAdmin())
                                    <x-dropdown-link :href="route('admin.dashboard')">Admin Panel</x-dropdown-link>
                                @endif
                                <x-dropdown-link :href="route('profile.edit')">Profile</x-dropdown-link>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <x-dropdown-link :href="route('logout')" onclick="event.preventDefault(); this.closest('form').submit();">Log Out</x-dropdown-link>
                                </form>
                            </x-slot>
                        </x-dropdown>
                    @else
                        <a href="{{ route('login') }}" class="text-gray-700 dark:text-gray-200 hover:text-indigo-600">Login</a>
                        <a href="{{ route('register') }}" class="text-gray-700 dark:text-gray-200 hover:text-indigo-600">Register</a>
                    @endauth
                    </div>
                </div>
            </div>
        </nav>
        <!-- Main Content -->
        <main class="flex-1 container mx-auto px-4 py-8">
            @yield('content')
        </main>
        <!-- Footer -->
        <footer class="bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 py-6 mt-auto">
            <div class="container mx-auto px-4 text-center text-gray-500 dark:text-gray-400">
                &copy; {{ date('Y') }} E-Commerce. All rights reserved.
            </div>
        </footer>
        <script>
            window.deferLoadingAlpine = function (callback) {
                window.addEventListener('alpine:initialized', callback);
            };
        </script>
        @livewireScripts
        @stack('scripts')
        <!-- Choices.js JS -->
        <script src="https://cdn.jsdelivr.net/npm/choices.js/public/assets/scripts/choices.min.js"></script>
        <script>
        function updateCartCount() {
            fetch('/cart/count')
                .then(response => response.json())
                .then(data => {
                    const badge = document.getElementById('cart-count');
                    if (badge) {
                        badge.textContent = data.count;
                        badge.style.display = data.count > 0 ? 'inline-flex' : 'none';
                    }
                });
        }
        function updateFavouritesCount() {
            fetch('/favourites/count')
                .then(response => response.json())
                .then(data => {
                    const badge = document.getElementById('favourites-count');
                    if (badge) {
                        badge.textContent = data.count;
                        badge.style.display = data.count > 0 ? 'inline-flex' : 'none';
                    }
                });
        }
        document.addEventListener('DOMContentLoaded', function() {
            updateCartCount();
            updateFavouritesCount();
        });
        </script>
    </body>
</html>
