<header class="flex justify-between items-center py-4 px-6 bg-white dark:bg-gray-800 border-b-2 border-gray-200 dark:border-gray-700">
    <div class="flex items-center">
        <!-- Mobile menu button -->
        <button @click="sidebarOpen = !sidebarOpen" class="text-gray-500 focus:outline-none lg:hidden">
            <svg class="h-6 w-6" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M4 6H20M4 12H20M4 18H11Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
        </button>
    </div>

    <div class="flex items-center space-x-4">
        <!-- Language Switcher -->
        <x-language-switcher />

        <!-- Theme Switcher -->
        <x-theme-switcher />

        <!-- User Dropdown -->
        <div x-data="{ dropdownOpen: false }" @click.away="dropdownOpen = false" class="relative">
            <button @click="dropdownOpen = !dropdownOpen" class="flex items-center space-x-2 relative focus:outline-none">
                <h2 class="text-sm font-medium text-gray-700 dark:text-gray-200">{{ Auth::user()->name }}</h2>
                <svg class="h-5 w-5 text-gray-500 dark:text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                </svg>
            </button>

            <div x-show="dropdownOpen" x-transition class="absolute right-0 mt-2 w-48 bg-white dark:bg-gray-800 rounded-md overflow-hidden shadow-xl z-10">
                <a href="{{ route('profile.edit') }}" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700">{{ __('admin.profile') }}</a>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <a href="{{ route('logout') }}"
                       onclick="event.preventDefault(); this.closest('form').submit();"
                       class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700">{{ __('admin.log_out') }}</a>
                </form>
            </div>
        </div>
    </div>
</header> 