<x-app-layout>
    <div class="bg-white dark:bg-gray-900">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <h1 class="text-3xl font-bold tracking-tight text-gray-900 dark:text-white mb-8">Frequently Asked Questions (F.A.Q.)</h1>
            
            <div class="space-y-4">
                <div x-data="{ open: false }" class="bg-gray-50 dark:bg-gray-800 rounded-lg">
                    <h2>
                        <button type="button" @click="open = !open" class="flex items-center justify-between w-full p-6 font-semibold text-left text-gray-900 dark:text-white">
                            <span>What is your return policy?</span>
                            <svg :class="{'rotate-180': open, 'rotate-0': !open}" class="w-6 h-6 transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                        </button>
                    </h2>
                    <div x-show="open" class="p-6 pt-0">
                        <p class="text-gray-500 dark:text-gray-400">Our return policy lasts 30 days. If 30 days have gone by since your purchase, unfortunately we can't offer you a refund or exchange.</p>
                    </div>
                </div>

                <div x-data="{ open: false }" class="bg-gray-50 dark:bg-gray-800 rounded-lg">
                    <h2>
                        <button type="button" @click="open = !open" class="flex items-center justify-between w-full p-6 font-semibold text-left text-gray-900 dark:text-white">
                            <span>How do I track my order?</span>
                            <svg :class="{'rotate-180': open, 'rotate-0': !open}" class="w-6 h-6 transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                        </button>
                    </h2>
                    <div x-show="open" class="p-6 pt-0">
                        <p class="text-gray-500 dark:text-gray-400">Once your order has shipped, you will receive an email with a tracking number.</p>
                    </div>
                </div>
                
                <div x-data="{ open: false }" class="bg-gray-50 dark:bg-gray-800 rounded-lg">
                    <h2>
                        <button type="button" @click="open" class="flex items-center justify-between w-full p-6 font-semibold text-left text-gray-900 dark:text-white">
                            <span>Do you ship internationally?</span>
                            <svg :class="{'rotate-180': open, 'rotate-0': !open}" class="w-6 h-6 transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                        </button>
                    </h2>
                    <div x-show="open" class="p-6 pt-0">
                        <p class="text-gray-500 dark:text-gray-400">Yes, we ship to most countries worldwide. Shipping costs will be calculated at checkout.</p>
                    </div>
                </div>

            </div>
        </div>
    </div>
</x-app-layout> 