@extends('layouts.app')

@section('content')
<div class="bg-white dark:bg-gray-900">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <!-- Search Results Header -->
        @if(request('search'))
            <div class="mb-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">
                            Search Results for "{{ request('search') }}"
                        </h1>
                        <p class="text-gray-600 dark:text-gray-400 mt-1">
                            Found {{ $products->total() }} product(s)
                        </p>
                    </div>
                    <a href="{{ route('products.index') }}" class="text-indigo-600 hover:text-indigo-500 font-medium">
                        Clear Search
                    </a>
                </div>
            </div>
        @endif

        <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
            <!-- Sidebar -->
            <aside class="lg:col-span-1">
                <div class="sticky top-8">
                    <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Filters</h2>
                    
                    <!-- Search Bar in Sidebar -->
                    <div class="mb-6">
                        <form method="GET" action="{{ route('products.index') }}" class="space-y-4">
                            <div>
                                <label for="search" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Search Products</label>
                                <div class="relative">
                                    <input type="text" 
                                           id="search" 
                                           name="search" 
                                           value="{{ request('search') }}"
                                           placeholder="Search by name, description, category..." 
                                           class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:placeholder-gray-400">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Preserve other filters when searching -->
                            @if(request('category'))
                                @foreach((array) request('category') as $cat)
                                    <input type="hidden" name="category[]" value="{{ $cat }}">
                                @endforeach
                            @endif
                            @if(request('vendor'))
                                @foreach((array) request('vendor') as $ven)
                                    <input type="hidden" name="vendor[]" value="{{ $ven }}">
                                @endforeach
                            @endif
                            @if(request('tags'))
                                @foreach((array) request('tags') as $tag)
                                    <input type="hidden" name="tags[]" value="{{ $tag }}">
                                @endforeach
                            @endif
                            @if(request('min_price'))
                                <input type="hidden" name="min_price" value="{{ request('min_price') }}">
                            @endif
                            @if(request('max_price'))
                                <input type="hidden" name="max_price" value="{{ request('max_price') }}">
                            @endif
                            @if(request('sort'))
                                <input type="hidden" name="sort" value="{{ request('sort') }}">
                            @endif
                            
                            <button type="submit" class="w-full bg-indigo-600 text-white py-2 px-4 rounded-md hover:bg-indigo-700">
                                Search
                            </button>
                        </form>
                    </div>

                    <form method="GET" action="{{ route('products.index') }}">
                        <!-- Preserve search when filtering -->
                        @if(request('search'))
                            <input type="hidden" name="search" value="{{ request('search') }}">
                        @endif
                        
                        <div class="space-y-4">
                            <div>
                                <label for="category" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Category</label>
                                <select id="category" name="category[]" multiple class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md dark:bg-gray-800 dark:border-gray-600 dark:text-white">
                                    @foreach($categories as $category)
                                        <option value="{{ $category->slug }}" {{ (collect(request('category'))->contains($category->slug)) ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div>
                                <label for="vendor" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Vendor</label>
                                <select id="vendor" name="vendor[]" multiple class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md dark:bg-gray-800 dark:border-gray-600 dark:text-white">
                                    @foreach($vendors as $vendor)
                                        <option value="{{ $vendor->id }}" {{ (collect(request('vendor'))->contains($vendor->id)) ? 'selected' : '' }}>{{ $vendor->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div>
                                <label for="tags" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Tags</label>
                                <select id="tags" name="tags[]" multiple class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md dark:bg-gray-800 dark:border-gray-600 dark:text-white">
                                    @foreach($tags as $tag)
                                        <option value="{{ $tag->id }}" {{ (collect(request('tags'))->contains($tag->id)) ? 'selected' : '' }}>{{ $tag->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label for="min_price" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Min Price</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <input type="number" id="min_price" name="min_price" value="{{ request('min_price') }}" placeholder="0" class="price-input block w-full pl-3 pr-8 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md dark:bg-gray-800 dark:border-gray-600 dark:text-white" step="10">
                                    </div>
                                </div>
                                <div>
                                    <label for="max_price" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Max Price</label>
                                    <div class="mt-1 relative rounded-md shadow-sm">
                                        <input type="number" id="max_price" name="max_price" value="{{ request('max_price') }}" placeholder="1000" class="price-input block w-full pl-3 pr-8 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md dark:bg-gray-800 dark:border-gray-600 dark:text-white" step="10">
                                    </div>
                                </div>
                            </div>
                            <div class="mb-4 mt-4">
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Price Range</label>
                                <div id="price-slider" class="my-4"></div>
                                <div class="flex justify-between text-xs text-gray-500 dark:text-gray-400 mt-1">
                                    <span id="range_min_label">{{ request('min_price', 0) }}</span>
                                    <span id="range_max_label">{{ request('max_price', 100000) }}</span>
                                </div>
                            </div>
                            <div>
                                <label for="sidebar-sort" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Sort by</label>
                                <select id="sidebar-sort" name="sort" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md dark:bg-gray-800 dark:border-gray-600 dark:text-white">
                                    <option value="latest" {{ request('sort', 'latest') == 'latest' ? 'selected' : '' }}>Latest</option>
                                    <option value="name" {{ request('sort') == 'name' ? 'selected' : '' }}>Name (A-Z)</option>
                                    <option value="name_desc" {{ request('sort') == 'name_desc' ? 'selected' : '' }}>Name (Z-A)</option>
                                    <option value="price_asc" {{ request('sort') == 'price_asc' ? 'selected' : '' }}>Price: Low to High</option>
                                    <option value="price_desc" {{ request('sort') == 'price_desc' ? 'selected' : '' }}>Price: High to Low</option>
                                    <option value="featured" {{ request('sort') == 'featured' ? 'selected' : '' }}>Featured</option>
                                </select>
                            </div>
                            <div class="flex space-x-2">
                                <button type="submit" class="w-full bg-indigo-600 text-white py-2 px-4 rounded-md hover:bg-indigo-700">Apply</button>
                                <a href="{{ route('products.index') }}" class="w-full text-center bg-gray-200 text-gray-800 py-2 px-4 rounded-md hover:bg-gray-300">Clear</a>
                            </div>
                        </div>
                    </form>
                </div>
            </aside>
            <!-- Product Grid -->
            <main class="lg:col-span-3">
                @if(!request('search'))
                <div class="flex justify-between items-center mb-6">
                    <h1 class="text-3xl font-bold tracking-tight text-gray-900 dark:text-white">Products</h1>
                        <div class="flex items-center gap-4">
                    <p class="text-sm text-gray-500 dark:text-gray-400">{{ $products->total() }} items</p>
                            <form method="GET" action="{{ route('products.index') }}" class="flex items-center gap-2">
                                @if(request('search'))
                                    <input type="hidden" name="search" value="{{ request('search') }}">
                                @endif
                                @if(request('category'))
                                    @foreach((array) request('category') as $cat)
                                        <input type="hidden" name="category[]" value="{{ $cat }}">
                                    @endforeach
                                @endif
                                @if(request('vendor'))
                                    @foreach((array) request('vendor') as $ven)
                                        <input type="hidden" name="vendor[]" value="{{ $ven }}">
                                    @endforeach
                                @endif
                                @if(request('tags'))
                                    @foreach((array) request('tags') as $tag)
                                        <input type="hidden" name="tags[]" value="{{ $tag }}">
                                    @endforeach
                                @endif
                                @if(request('min_price'))
                                    <input type="hidden" name="min_price" value="{{ request('min_price') }}">
                                @endif
                                @if(request('max_price'))
                                    <input type="hidden" name="max_price" value="{{ request('max_price') }}">
                                @endif
                                <label for="sort" class="text-sm font-medium text-gray-700 dark:text-gray-300">Sort by:</label>
                                <select id="sort" name="sort" onchange="this.form.submit()" class="text-sm border border-gray-300 rounded-md px-3 py-1 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                                    <option value="latest" {{ request('sort', 'latest') == 'latest' ? 'selected' : '' }}>Latest</option>
                                    <option value="name" {{ request('sort') == 'name' ? 'selected' : '' }}>Name A-Z</option>
                                    <option value="price_asc" {{ request('sort') == 'price_asc' ? 'selected' : '' }}>Price: Low to High</option>
                                    <option value="price_desc" {{ request('sort') == 'price_desc' ? 'selected' : '' }}>Price: High to Low</option>
                                    <option value="featured" {{ request('sort') == 'featured' ? 'selected' : '' }}>Featured</option>
                                </select>
                            </form>
                        </div>
                    </div>
                @else
                    <div class="flex justify-between items-center mb-6">
                        <div class="flex items-center gap-4">
                            <form method="GET" action="{{ route('products.index') }}" class="flex items-center gap-2">
                                @if(request('search'))
                                    <input type="hidden" name="search" value="{{ request('search') }}">
                                @endif
                                @if(request('category'))
                                    @foreach((array) request('category') as $cat)
                                        <input type="hidden" name="category[]" value="{{ $cat }}">
                                    @endforeach
                                @endif
                                @if(request('vendor'))
                                    @foreach((array) request('vendor') as $ven)
                                        <input type="hidden" name="vendor[]" value="{{ $ven }}">
                                    @endforeach
                                @endif
                                @if(request('tags'))
                                    @foreach((array) request('tags') as $tag)
                                        <input type="hidden" name="tags[]" value="{{ $tag }}">
                                    @endforeach
                                @endif
                                @if(request('min_price'))
                                    <input type="hidden" name="min_price" value="{{ request('min_price') }}">
                                @endif
                                @if(request('max_price'))
                                    <input type="hidden" name="max_price" value="{{ request('max_price') }}">
                                @endif
                                <label for="sort" class="text-sm font-medium text-gray-700 dark:text-gray-300">Sort by:</label>
                                <select id="sort" name="sort" onchange="this.form.submit()" class="text-sm border border-gray-300 rounded-md px-3 py-1 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                                    <option value="latest" {{ request('sort', 'latest') == 'latest' ? 'selected' : '' }}>Latest</option>
                                    <option value="name" {{ request('sort') == 'name' ? 'selected' : '' }}>Name A-Z</option>
                                    <option value="price_asc" {{ request('sort') == 'price_asc' ? 'selected' : '' }}>Price: Low to High</option>
                                    <option value="price_desc" {{ request('sort') == 'price_desc' ? 'selected' : '' }}>Price: High to Low</option>
                                    <option value="featured" {{ request('sort') == 'featured' ? 'selected' : '' }}>Featured</option>
                                </select>
                            </form>
                        </div>
                </div>
                @endif
                
                @if($products->count() > 0)
                    <div class="grid grid-cols-1 gap-y-10 gap-x-6 sm:grid-cols-2 lg:grid-cols-3 xl:gap-x-8">
                        @foreach($products as $product)
                            <x-product-card :product="$product"/>
                        @endforeach
                    </div>
                    <div class="mt-8">
                        {{ $products->withQueryString()->links() }}
                    </div>
                @else
                    <div class="text-center py-16">
                        @if(request('search'))
                            <div class="mb-4">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                </svg>
                            </div>
                            <h3 class="text-lg font-medium text-gray-900 dark:text-white">{{ __('no_products_found') }}</h3>
                            <p class="mt-1 text-sm text-gray-500">{{ __('no_products_match_search', ['search' => request('search')]) }}</p>
                            <div class="mt-6">
                                <a href="{{ route('products.index') }}" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700">
                                    {{ __('view_all_products') }}
                                </a>
                            </div>
                        @else
                        <h3 class="text-lg font-medium text-gray-900 dark:text-white">{{ __('no_products_found_alt') }}</h3>
                        <p class="mt-1 text-sm text-gray-500">{{ __('try_adjusting_filters') }}</p>
                        @endif
                    </div>
                @endif
            </main>
        </div>
    </div>
</div>
@endsection

@push('head')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/nouislider@15.7.1/dist/nouislider.min.css" />
    <style>
        /* Custom noUiSlider styles for a modern, slim look */
        #price-slider {
            margin-top: 1.5rem;
            margin-bottom: 1.5rem;
            padding: 0 0.5rem;
        }
        .noUi-target {
            background: transparent;
            border: none;
            box-shadow: none;
            height: 6px;
        }
        .noUi-base {
            height: 6px;
        }
        .noUi-connects {
            background: #6366f1; /* indigo-500 */
            border-radius: 3px;
        }
        .noUi-connect {
            background: #6366f1; /* indigo-500 */
        }
        .noUi-handle {
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background: #fff;
            border: 2px solid #6366f1;
            box-shadow: 0 2px 8px rgba(99,102,241,0.15);
            top: -7px;
            transition: border-color 0.2s, box-shadow 0.2s;
        }
        .noUi-handle:focus, .noUi-handle:hover {
            border-color: #4f46e5; /* indigo-600 */
            box-shadow: 0 4px 12px rgba(99,102,241,0.25);
        }
        .noUi-tooltip {
            background: #6366f1;
            color: #fff;
            border-radius: 4px;
            font-size: 0.85rem;
            padding: 2px 8px;
            border: none;
            box-shadow: 0 2px 8px rgba(99,102,241,0.10);
        }
        /* Dark mode support */
        html.dark .noUi-connects, html.dark .noUi-connect {
            background: #818cf8;
        }
        html.dark .noUi-handle {
            background: #18181b;
            border-color: #818cf8;
        }
        html.dark .noUi-tooltip {
            background: #818cf8;
            color: #18181b;
        }
    </style>
@endpush
@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/nouislider@15.7.1/dist/nouislider.min.js"></script>
<script>
    document.querySelectorAll('.price-stepper').forEach(button => {
        button.addEventListener('click', function() {
            const inputId = this.dataset.input;
            const step = parseInt(this.dataset.step);
            const input = document.getElementById(inputId);
            let currentValue = parseInt(input.value) || 0;
            input.value = Math.max(0, currentValue + step);
        });
    });

    // Choices.js initialization for multi-selects
    document.addEventListener('DOMContentLoaded', function() {
        const selects = ['#category', '#vendor', '#tags'];
        selects.forEach(function(sel) {
            const el = document.querySelector(sel);
            if (el) {
                new Choices(el, {
                    removeItemButton: true,
                    shouldSort: false,
                    placeholder: true,
                    placeholderValue: el.getAttribute('placeholder') || '',
                    searchPlaceholderValue: 'Search...'
                });
            }
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
        const minInput = document.getElementById('min_price');
        const maxInput = document.getElementById('max_price');
        const minLabel = document.getElementById('range_min_label');
        const maxLabel = document.getElementById('range_max_label');
        const slider = document.getElementById('price-slider');
        const minValue = parseInt(minInput.value) || 0;
        const maxValue = parseInt(maxInput.value) || 100000;

        if (slider && minInput && maxInput) {
            noUiSlider.create(slider, {
                start: [minValue, maxValue],
                connect: true,
                step: 10,
                range: {
                    'min': 0,
                    'max': 100000
                },
                tooltips: [true, true],
                format: {
                    to: function (value) { return Math.round(value); },
                    from: function (value) { return Number(value); }
                }
            });

            slider.noUiSlider.on('update', function(values, handle) {
                minInput.value = values[0];
                maxInput.value = values[1];
                minLabel.textContent = values[0];
                maxLabel.textContent = values[1];
            });

            minInput.addEventListener('input', function() {
                slider.noUiSlider.set([this.value, null]);
            });
            maxInput.addEventListener('input', function() {
                slider.noUiSlider.set([null, this.value]);
            });
        }
    });
</script>
@endpush
