@extends('layouts.app')

@section('content')
{{-- Hero Section --}}
<div class="bg-gray-800 text-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div class="text-center">
            <h1 class="text-4xl font-extrabold tracking-tight sm:text-5xl md:text-6xl">
                <span class="block">The best products</span>
                <span class="block text-indigo-400">for your needs.</span>
            </h1>
            <p class="mt-3 max-w-md mx-auto text-base text-gray-400 sm:text-lg md:mt-5 md:text-xl md:max-w-3xl">
                Anim aute id magna aliqua ad ad non deserunt sunt. Qui irure qui lorem cupidatat commodo. Elit sunt amet fugiat veniam occaecat fugiat aliqua.
            </p>
            <div class="mt-5 max-w-md mx-auto sm:flex sm:justify-center md:mt-8">
                <div class="rounded-md shadow">
                    <a href="{{ route('products.index') }}" class="w-full flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 md:py-4 md:text-lg md:px-10">
                        Shop Now
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Categories Marquee --}}
@if($categories->isNotEmpty())
    <div class="bg-gray-50 dark:bg-gray-900 py-4">
        <div class="relative flex overflow-x-hidden group">
            <div class="py-2 animate-marquee whitespace-nowrap pause-on-hover">
                @foreach ($categories as $category)
                    <a href="{{ route('products.index', ['category' => $category->slug]) }}" class="inline-block mx-4 px-6 py-2 bg-white dark:bg-gray-800 rounded-lg shadow-md hover:shadow-xl transition-shadow duration-300">
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">{{ $category->name }}</span>
                    </a>
                @endforeach
            </div>
            <div class="absolute top-0 py-2 animate-marquee2 whitespace-nowrap pause-on-hover">
                @foreach ($categories as $category)
                    <a href="{{ route('products.index', ['category' => $category->slug]) }}" class="inline-block mx-4 px-6 py-2 bg-white dark:bg-gray-800 rounded-lg shadow-md hover:shadow-xl transition-shadow duration-300">
                        <span class="text-lg font-semibold text-gray-800 dark:text-gray-200">{{ $category->name }}</span>
                    </a>
                @endforeach
            </div>
        </div>
    </div>
@endif

{{-- Featured Products --}}
<div class="py-12 bg-white dark:bg-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-extrabold tracking-tight text-gray-900 dark:text-white mb-8 text-center">Featured Products</h2>
        <div class="mt-6 grid grid-cols-1 gap-y-10 gap-x-6 sm:grid-cols-2 lg:grid-cols-4 xl:gap-x-8">
            @foreach($newArrivals as $product)
                <x-product-card :product="$product"/>
            @endforeach
        </div>
    </div>
</div>

{{-- Brand Marquee --}}
@if($brands->isNotEmpty())
    <div class="bg-white dark:bg-gray-800 py-12">
        <div class="relative flex overflow-x-hidden group">
            <div class="py-2 animate-marquee whitespace-nowrap pause-on-hover">
                @foreach ($brands as $brand)
                    <div class="inline-block mx-8">
                    <img src="{{ asset('storage/' . $brand->logo) }}" alt="{{ $brand->name }}" class="h-12">
                    </div>
                @endforeach
                @foreach ($brands as $brand)
                    <div class="inline-block mx-8">
                    <img src="{{ asset('storage/' . $brand->logo) }}" alt="{{ $brand->name }}" class="h-12">
                    </div>
                @endforeach
                @foreach ($brands as $brand)
                    <div class="inline-block mx-8">
                    <img src="{{ asset('storage/' . $brand->logo) }}" alt="{{ $brand->name }}" class="h-12">
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endif

{{-- Full-width Image --}}
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="flex justify-center">
        <img src="https://images.unsplash.com/photo-1524758631624-e2822e304c36?q=80&w=2070&auto=format&fit=crop" alt="Office desk" class="rounded-lg shadow-xl">
    </div>
</div>
@endsection
