<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ProductController as AdminProductController;
use App\Http\Controllers\Admin\BrandController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\PageController;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Product;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    $currency = request('currency', session('currency', 'USD'));
    session(['currency' => $currency]);
    $newArrivals = \App\Models\Product::active()->latest()->take(4)->get(); // Use active() to hide inactive products
    $categories = \App\Models\Category::all();
    $brands = \App\Models\Brand::all();
    return view('welcome', compact('newArrivals', 'categories', 'brands'));
})->middleware(['web', \App\Http\Middleware\SetLocale::class])->name('home');

Route::get('/search', [HomeController::class, 'search'])->name('search');

Route::get('/products', [ProductController::class, 'index'])
    ->middleware(['web', \App\Http\Middleware\SetLocale::class])
    ->name('products.index');

Route::get('/products/{product}', [ProductController::class, 'show'])
    ->middleware(['web', \App\Http\Middleware\SetLocale::class])
    ->name('products.show');

Route::get('/category/{category}', [ProductController::class, 'category'])->name('products.category');

Route::get('/about', [PageController::class, 'about'])->name('about');
Route::get('/services', [PageController::class, 'services'])->name('services');
Route::get('/contact', [PageController::class, 'contact'])->name('contact');
Route::post('/contact', [PageController::class, 'sendContactForm'])->name('contact.send');
Route::get('/terms', [PageController::class, 'terms'])->name('terms');
Route::get('/faq', [PageController::class, 'faq'])->name('faq');

Route::prefix('cart')->name('cart.')->group(function () {
    Route::get('/', [CartController::class, 'index'])->name('index');
    Route::post('/add', [CartController::class, 'add'])->name('add');
    Route::post('/update', [CartController::class, 'update'])->name('update');
    Route::post('/remove', [CartController::class, 'remove'])->name('remove');
    Route::post('/clear', [CartController::class, 'clear'])->name('clear');
    Route::get('/count', [CartController::class, 'count'])->name('count');
});

Route::get('/dashboard', function () {
    if (auth()->user()->isAdmin()) {
        return redirect()->route('admin.dashboard');
    }
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::prefix('checkout')->name('checkout.')->group(function () {
        Route::get('/', [CheckoutController::class, 'index'])->name('index');
        Route::post('/process', [CheckoutController::class, 'process'])->name('process');
        Route::post('/confirm-payment', [CheckoutController::class, 'confirmPayment'])->name('confirm-payment');
        Route::get('/success/{order}', [CheckoutController::class, 'success'])->name('success');
    });

    Route::get('/favourites', [\App\Http\Controllers\FavouriteController::class, 'index'])->name('favourites.index');
    Route::post('/favourites', [\App\Http\Controllers\FavouriteController::class, 'store'])->name('favourites.store');
    Route::delete('/favourites', [\App\Http\Controllers\FavouriteController::class, 'destroy'])->name('favourites.destroy');
    Route::get('/favourites/count', [\App\Http\Controllers\FavouriteController::class, 'count']);
});

Route::middleware(['web', 'auth', 'admin', \App\Http\Middleware\SetLocale::class])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', function () {
        return redirect()->route('admin.dashboard');
    });
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');

    Route::resource('products', AdminProductController::class);
    Route::post('products/bulk-action', [AdminProductController::class, 'bulkAction'])->name('products.bulk-action');
    Route::resource('categories', CategoryController::class);
    Route::resource('brands', BrandController::class)->except(['show']);
    Route::resource('vendors', \App\Http\Controllers\Admin\VendorController::class)->except(['show']);
    Route::resource('tags', \App\Http\Controllers\Admin\TagController::class)->except(['show']);
});

Route::get('/test-locale', function (\Illuminate\Http\Request $request) {
    \Log::debug('Test-locale route hit. Lang param: ' . $request->get('lang'));
    return 'Locale: ' . app()->getLocale() . ', Lang param: ' . $request->get('lang');
})->middleware(['web', \App\Http\Middleware\SetLocale::class]);

require __DIR__.'/auth.php';
