<?php $__env->startSection('content'); ?>
    <div class="container mx-auto px-4 py-8">
        <h2 class="text-2xl font-semibold text-gray-800 mb-6"><?php echo e(__('Admin Dashboard')); ?></h2>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Total Orders -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h3 class="text-lg font-semibold text-gray-600 mb-2"><?php echo e(__('Total Orders')); ?></h3>
                <p class="text-3xl font-bold text-gray-900"><?php echo e($stats['total_orders']); ?></p>
            </div>

            <!-- Total Revenue -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h3 class="text-lg font-semibold text-gray-600 mb-2"><?php echo e(__('Total Revenue')); ?></h3>
                <p class="text-3xl font-bold text-gray-900">$<?php echo e(number_format($stats['total_revenue'], 2)); ?></p>
            </div>

            <!-- Total Customers -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h3 class="text-lg font-semibold text-gray-600 mb-2"><?php echo e(__('Total Customers')); ?></h3>
                <p class="text-3xl font-bold text-gray-900"><?php echo e($stats['total_customers']); ?></p>
            </div>

            <!-- Total Products -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h3 class="text-lg font-semibold text-gray-600 mb-2"><?php echo e(__('Total Products')); ?></h3>
                <p class="text-3xl font-bold text-gray-900"><?php echo e($stats['total_products']); ?></p>
            </div>
        </div>

        <div class="mt-8 grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Recent Orders -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h3 class="text-lg font-semibold text-gray-800 mb-4"><?php echo e(__('Recent Orders')); ?></h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="py-2 px-4 border-b">Order ID</th>
                                <th class="py-2 px-4 border-b">Customer</th>
                                <th class="py-2 px-4 border-b">Status</th>
                                <th class="py-2 px-4 border-b">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $stats['recent_orders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="py-2 px-4 border-b text-center">#<?php echo e($order->id); ?></td>
                                    <td class="py-2 px-4 border-b"><?php echo e($order->user->name); ?></td>
                                    <td class="py-2 px-4 border-b text-center">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full
                                            <?php if($order->payment_status == 'paid'): ?> bg-green-200 text-green-800 <?php else: ?> bg-yellow-200 text-yellow-800 <?php endif; ?>">
                                            <?php echo e(ucfirst($order->payment_status)); ?>

                                        </span>
                                    </td>
                                    <td class="py-2 px-4 border-b text-right">$<?php echo e(number_format($order->total_amount, 2)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="py-4 px-4 border-b text-center text-gray-500">No recent orders found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Low Stock Products -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h3 class="text-lg font-semibold text-gray-800 mb-4"><?php echo e(__('Low Stock Products')); ?></h3>
                 <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="py-2 px-4 border-b">Product</th>
                                <th class="py-2 px-4 border-b">Stock</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $stats['low_stock_products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="py-2 px-4 border-b"><?php echo e($product->name); ?></td>
                                    <td class="py-2 px-4 border-b text-center">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-200 text-red-800">
                                            <?php echo e($product->stock_quantity); ?>

                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="2" class="py-4 px-4 border-b text-center text-gray-500">No products with low stock.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tamerlan/PhpstormProjects/e-commerce-new/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>