<?php $__env->startSection('title', 'Admin - Categories'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-semibold text-gray-800"><?php echo e(__('admin.category_management')); ?></h1>
        <a href="<?php echo e(route('admin.categories.create')); ?>" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
            <?php echo e(__('admin.add_new_category')); ?>

        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
            <p><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4" role="alert">
            <p><?php echo e(session('error')); ?></p>
        </div>
    <?php endif; ?>

    <div class="bg-white shadow-md rounded-lg overflow-hidden">
        <div class="px-6 py-4">
            <h2 class="text-xl font-semibold text-gray-700"><?php echo e(__('admin.all_categories')); ?></h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.id')); ?></th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.name')); ?></th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.slug')); ?></th>
                        <th class="py-3 px-6 text-center text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.status')); ?></th>
                        <th class="py-3 px-6 text-right text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.actions')); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="py-4 px-6 whitespace-nowrap text-sm text-gray-500"><?php echo e($category->id); ?></td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo e($category->name); ?></td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm text-gray-500"><?php echo e($category->slug); ?></td>
                            <td class="py-4 px-6 whitespace-nowrap text-center">
                                <?php if($category->is_active): ?>
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                        <?php echo e(__('admin.active')); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                        <?php echo e(__('admin.inactive')); ?>

                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-right text-sm font-medium">
                                <a href="<?php echo e(route('admin.categories.edit', $category)); ?>" class="text-indigo-600 hover:text-indigo-900 mr-4"><?php echo e(__('admin.edit')); ?></a>
                                <button type="button" class="text-red-600 hover:text-red-900 delete-category-btn" data-url="<?php echo e(route('admin.categories.destroy', $category)); ?>"><?php echo e(__('admin.delete')); ?></button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="py-4 px-6 text-center text-gray-500">
                                <?php echo e(__('admin.no_categories_found')); ?>

                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if($categories->hasPages()): ?>
        <div class="px-6 py-4">
            <?php echo e($categories->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Auto-dismiss server-side success alert
    const serverAlert = document.querySelector('.bg-green-100[role="alert"]');
    if (serverAlert) {
        setTimeout(() => serverAlert.remove(), 500);
    }

    document.querySelectorAll('.delete-category-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            const url = this.getAttribute('data-url');
            const row = this.closest('tr');
            fetch(url, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json',
                },
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    row.remove();
                    showCategorySuccess('<?php echo e(__('admin.category_deleted_successfully')); ?>');
                } else {
                    alert(data.message || '<?php echo e(__('admin.failed_to_delete_category')); ?>');
                }
            })
            .catch(() => alert('<?php echo e(__('admin.failed_to_delete_category')); ?>'));
        });
    });

    function showCategorySuccess(msg) {
        let alert = document.createElement('div');
        alert.className = 'bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4';
        alert.role = 'alert';
        alert.innerHTML = `<p>${msg}</p>`;
        document.querySelector('.container').prepend(alert);
        setTimeout(() => alert.remove(), 500);
    }
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tamerlan/PhpstormProjects/e-commerce-new/resources/views/admin/categories/index.blade.php ENDPATH**/ ?>