<div class="group relative">
    <?php if(auth()->guard()->check()): ?>
        <?php if(!Auth::user()->isAdmin()): ?>
            <button type="button"
                class="absolute top-2 right-2 z-10 p-1 rounded-full bg-white/80 hover:bg-pink-100 transition"
                x-data="{favourited: <?php echo e(optional(Auth::user()->favourites)->contains('product_id', $product->id) ? 'true' : 'false'); ?>, loading: false}"
                :class="favourited ? 'text-pink-500' : 'text-gray-400'"
                @click.prevent="
                    if (loading) return;
                    loading = true;
                    fetch(favourited ? '<?php echo e(route('favourites.destroy')); ?>' : '<?php echo e(route('favourites.store')); ?>', {
                        method: favourited ? 'DELETE' : 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({ product_id: <?php echo e($product->id); ?> })
                    })
                    .then(r => r.json())
                    .then(data => {
                        if(data.success) favourited = !favourited;
                        if(typeof updateFavouritesCount === 'function') updateFavouritesCount();
                    })
                    .finally(() => loading = false);
                "
                title="Add to Favourites">
                <template x-if="!favourited">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-6 h-6">
                        <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41 0.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z" stroke="currentColor" stroke-width="2" fill="none"/>
                    </svg>
                </template>
                <template x-if="favourited">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24" class="w-6 h-6">
                        <path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41 0.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z"/>
                    </svg>
                </template>
            </button>
        <?php endif; ?>
    <?php endif; ?>
    <div class="w-full min-h-80 bg-gray-200 aspect-w-1 aspect-h-1 rounded-md overflow-hidden group-hover:opacity-75 lg:h-80 lg:aspect-none">
        <img src="<?php echo e($product->mainImage ? asset('storage/' . $product->mainImage->image_path) : ($product->images->first() ? asset('storage/' . $product->images->first()->image_path) : 'https://via.placeholder.com/400')); ?>" alt="<?php echo e($product->name); ?>" class="w-full h-full object-center object-cover lg:w-full lg:h-full">
    </div>
    <div class="mt-4 flex justify-between">
        <div>
            <h3 class="text-sm text-gray-700 dark:text-gray-200">
                <a href="<?php echo e(route('products.show', $product)); ?>">
                    <span aria-hidden="true" class="absolute inset-0"></span>
                    <?php echo e($product->getTranslation('name', app()->getLocale())); ?>

                </a>
            </h3>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400"><?php echo e($product->category ? $product->category->getTranslation('name', app()->getLocale()) : ''); ?></p>
        </div>
        <div>
            <?php
                $currency = session('currency', 'USD');
                $price = $product->getPriceInCurrency($currency);
                $finalPrice = $product->getFinalPriceInCurrency($currency);
                $symbol = $product->getCurrencySymbol($currency);
            ?>
            <?php if($product->isDiscounted()): ?>
                <p class="text-sm font-medium text-red-500">
                    <span class="line-through text-gray-500 dark:text-gray-400"><?php echo e($symbol); ?><?php echo e(number_format($price, 2)); ?></span>
                    <?php echo e($symbol); ?><?php echo e(number_format($finalPrice, 2)); ?>

                </p>
            <?php else: ?>
                <p class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e($symbol); ?><?php echo e(number_format($price, 2)); ?></p>
            <?php endif; ?>
        </div>
    </div>
</div> <?php /**PATH /home/tamerlan/PhpstormProjects/e-commerce-new/resources/views/components/product-card.blade.php ENDPATH**/ ?>