<?php $__env->startSection('title', 'Admin - Products'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-semibold text-gray-800"><?php echo e(__('admin.product_management')); ?></h1>
        <div class="flex items-center gap-2">
            <a href="<?php echo e(route('admin.products.create')); ?>" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
                <?php echo e(__('admin.add_new_product')); ?>

            </a>
            <button type="button" id="bulk-delete-btn" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded hidden">
                <?php echo e(__('admin.delete_selected')); ?>

            </button>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
            <p><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>

    <div class="bg-white shadow-md rounded-lg overflow-hidden">
        <div class="px-6 py-4 flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <h2 class="text-xl font-semibold text-gray-700"><?php echo e(__('admin.all_products')); ?></h2>
            <form method="GET" action="" class="flex flex-wrap items-center gap-2 bg-gray-50 rounded-lg shadow-sm px-4 py-2">
                <label for="admin-sort" class="text-sm font-medium text-gray-700 whitespace-nowrap"><?php echo e(__('admin.sort_by')); ?></label>
                <select id="admin-sort" name="sort" onchange="this.form.submit()" class="text-sm border border-gray-300 rounded-md px-3 py-1 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500">
                    <option value="latest" <?php echo e(request('sort', 'latest') == 'latest' ? 'selected' : ''); ?>><?php echo e(__('admin.latest')); ?></option>
                    <option value="name" <?php echo e(request('sort') == 'name' ? 'selected' : ''); ?>><?php echo e(__('admin.name_a_z')); ?></option>
                    <option value="name_desc" <?php echo e(request('sort') == 'name_desc' ? 'selected' : ''); ?>><?php echo e(__('admin.name_z_a')); ?></option>
                    <option value="price_asc" <?php echo e(request('sort') == 'price_asc' ? 'selected' : ''); ?>><?php echo e(__('admin.price_low_to_high')); ?></option>
                    <option value="price_desc" <?php echo e(request('sort') == 'price_desc' ? 'selected' : ''); ?>><?php echo e(__('admin.price_high_to_low')); ?></option>
                    <option value="featured" <?php echo e(request('sort') == 'featured' ? 'selected' : ''); ?>><?php echo e(__('admin.featured')); ?></option>
                </select>
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="<?php echo e(__('admin.search_by_name_or_description')); ?>" class="text-sm border border-gray-300 rounded-md px-3 py-1 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 w-56" />
                <button type="submit" class="ml-1 px-4 py-1.5 bg-indigo-500 text-white rounded-md hover:bg-indigo-600 text-sm font-medium shadow"><?php echo e(__('admin.search')); ?></button>
            </form>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="py-3 px-4 text-center">
                            <input type="checkbox" id="select-all-products" class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                        </th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.image')); ?></th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.name')); ?></th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.category')); ?></th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.price')); ?></th>
                        <th class="py-3 px-6 text-center text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.stock')); ?></th>
                        <th class="py-3 px-6 text-center text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.status')); ?></th>
                        <th class="py-3 px-6 text-center text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.view')); ?></th>
                        <th class="py-3 px-6 text-right text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.actions')); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50" data-product-id="<?php echo e($product->id); ?>">
                            <td class="py-4 px-4 text-center">
                                <input type="checkbox" class="product-checkbox rounded border-gray-300 text-indigo-600 focus:ring-indigo-500" value="<?php echo e($product->id); ?>">
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap">
                                <img src="<?php echo e($product->mainImage ? asset('storage/' . $product->mainImage->image_path) : ($product->images->first() ? asset('storage/' . $product->images->first()->image_path) : 'https://via.placeholder.com/80')); ?>" alt="<?php echo e($product->name); ?>" class="w-16 h-16 object-cover rounded">
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900"><?php echo e($product->name); ?></div>
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm text-gray-500">
                                <?php echo e($product->category->name ?? 'N/A'); ?>

                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm text-gray-500">
                                <?php if($product->isDiscounted()): ?>
                                    <span class="line-through text-gray-500">$<?php echo e(number_format($product->price, 2)); ?></span>
                                    <span class="text-red-600 font-bold">$<?php echo e(number_format($product->final_price, 2)); ?></span>
                                <?php else: ?>
                                    <span>$<?php echo e(number_format($product->price, 2)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm text-gray-500 text-center">
                                <?php echo e($product->stock_quantity); ?>

                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-center">
                                <?php if($product->is_active): ?>
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                        <?php echo e(__('admin.active')); ?>

                                    </span>
                                <?php else: ?>
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                                        <?php echo e(__('admin.inactive')); ?>

                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="py-4 px-2 whitespace-nowrap text-center">
                                <a href="<?php echo e(route('products.show', $product)); ?>" target="_blank" title="<?php echo e(__('admin.view_product')); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="w-6 h-6 text-gray-500 hover:text-indigo-600 inline-block align-middle">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                    </svg>
                                    <span class="sr-only"><?php echo e(__('admin.view_product')); ?></span>
                                </a>
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-right text-sm font-medium">
                                <a href="<?php echo e(route('admin.products.edit', $product)); ?>" class="text-indigo-600 hover:text-indigo-900 mr-4"><?php echo e(__('admin.edit')); ?></a>
                                <button type="button" class="text-red-600 hover:text-red-900 delete-product-btn" data-url="<?php echo e(route('admin.products.destroy', $product)); ?>"><?php echo e(__('admin.delete')); ?></button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="py-4 px-6 text-center text-gray-500">
                                <?php echo e(__('admin.no_products_found')); ?>

                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if($products->hasPages()): ?>
        <div class="px-6 py-4">
            <?php echo e($products->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Auto-dismiss server-side success alert
    const serverAlert = document.querySelector('.bg-green-100[role="alert"]');
    if (serverAlert) {
        setTimeout(() => serverAlert.remove(), 500);
    }

    // Bulk select logic
    const selectAll = document.getElementById('select-all-products');
    const checkboxes = document.querySelectorAll('.product-checkbox');
    const bulkDeleteBtn = document.getElementById('bulk-delete-btn');

    function updateBulkDeleteBtn() {
        const anyChecked = Array.from(checkboxes).some(cb => cb.checked);
        bulkDeleteBtn.classList.toggle('hidden', !anyChecked);
    }

    if (selectAll) {
        selectAll.addEventListener('change', function() {
            checkboxes.forEach(cb => { cb.checked = selectAll.checked; });
            updateBulkDeleteBtn();
        });
    }
    checkboxes.forEach(cb => {
        cb.addEventListener('change', function() {
            if (!cb.checked && selectAll.checked) selectAll.checked = false;
            updateBulkDeleteBtn();
        });
    });

    bulkDeleteBtn.addEventListener('click', function() {
        const selected = Array.from(checkboxes).filter(cb => cb.checked).map(cb => cb.value);
        if (selected.length === 0) return;
        if (!confirm('<?php echo e(__('admin.are_you_sure_you_want_to_delete_the_selected_products')); ?>')) return;
        fetch("<?php echo e(route('admin.products.bulk-action')); ?>", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ action: 'delete', products: selected })
        })
        .then(res => res.json())
        .then(data => {
            if (data.success !== false) {
                selected.forEach(id => {
                    const row = document.querySelector(`tr[data-product-id='${id}']`);
                    if (row) row.remove();
                });
                showProductSuccess('<?php echo e(__('admin.selected_products_deleted_successfully')); ?>');
                selectAll.checked = false;
                updateBulkDeleteBtn();
            } else {
                alert(data.message || '<?php echo e(__('admin.failed_to_delete_selected_products')); ?>');
            }
        })
        .catch(() => alert('<?php echo e(__('admin.failed_to_delete_selected_products')); ?>'));
    });

    document.querySelectorAll('.delete-product-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            const url = this.getAttribute('data-url');
            const row = this.closest('tr');
            fetch(url, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json',
                },
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    row.remove();
                    showProductSuccess('<?php echo e(__('admin.product_deleted_successfully')); ?>');
                } else {
                    alert(data.message || '<?php echo e(__('admin.failed_to_delete_product')); ?>');
                }
            })
            .catch(() => alert('<?php echo e(__('admin.failed_to_delete_product')); ?>'));
        });
    });

    function showProductSuccess(msg) {
        let alert = document.createElement('div');
        alert.className = 'bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4';
        alert.role = 'alert';
        alert.innerHTML = `<p>${msg}</p>`;
        document.querySelector('.container').prepend(alert);
        setTimeout(() => alert.remove(), 500);
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tamerlan/PhpstormProjects/e-commerce-new/resources/views/admin/products/index.blade.php ENDPATH**/ ?>