<?php $__env->startSection('title', 'Admin - Brands'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-semibold text-gray-800"><?php echo e(__('admin.Brands')); ?></h1>
        <a href="<?php echo e(route('admin.brands.create')); ?>" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
            <?php echo e(__('admin.Add New Brand')); ?>

        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4" role="alert">
            <p><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>

    <div class="bg-white shadow-md rounded-lg overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full bg-white">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.Logo')); ?></th>
                        <th class="py-3 px-6 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.Name')); ?></th>
                        <th class="py-3 px-6 text-right text-xs font-medium text-gray-500 uppercase tracking-wider"><?php echo e(__('admin.Actions')); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50" data-brand-id="<?php echo e($brand->id); ?>">
                            <td class="py-4 px-6 whitespace-nowrap">
                                <?php if($brand->logo): ?>
                                    <img src="<?php echo e(asset('storage/' . $brand->logo)); ?>" alt="<?php echo e($brand->name); ?>" class="h-12 w-24 object-contain">
                                <?php else: ?>
                                    <span class="text-sm text-gray-500"><?php echo e(__('admin.No Logo')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-sm font-medium text-gray-900">
                                <?php echo e($brand->name); ?>

                            </td>
                            <td class="py-4 px-6 whitespace-nowrap text-right text-sm font-medium">
                                <a href="<?php echo e(route('admin.brands.edit', $brand)); ?>" class="text-indigo-600 hover:text-indigo-900 mr-4"><?php echo e(__('admin.Edit')); ?></a>
                                <button type="button" class="text-red-600 hover:text-red-900 delete-brand-btn" data-url="<?php echo e(route('admin.brands.destroy', $brand)); ?>"><?php echo e(__('admin.Delete')); ?></button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="3" class="py-4 px-6 text-center text-gray-500">
                                <?php echo e(__('admin.No brands found.')); ?>

                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-dismiss server-side success alert
    const serverAlert = document.querySelector('.bg-green-100[role="alert"]');
    if (serverAlert) {
        setTimeout(() => serverAlert.remove(), 500);
    }

    document.querySelectorAll('.delete-brand-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            const url = this.getAttribute('data-url');
            const row = this.closest('tr');
            fetch(url, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json',
                },
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    row.remove();
                    showBrandSuccess('<?php echo e(__('admin.Brand deleted successfully.')); ?>');
                } else {
                    alert(data.message || '<?php echo e(__('admin.Failed to delete brand.')); ?>');
                }
            })
            .catch(() => alert('<?php echo e(__('admin.Failed to delete brand.')); ?>'));
        });
    });

    function showBrandSuccess(msg) {
        let alert = document.createElement('div');
        alert.className = 'bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4';
        alert.role = 'alert';
        alert.innerHTML = `<p>${msg}</p>`;
        document.querySelector('.container').prepend(alert);
        setTimeout(() => alert.remove(), 500);
    }
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/tamerlan/PhpstormProjects/e-commerce-new/resources/views/admin/brands/index.blade.php ENDPATH**/ ?>